
#  CVE-2023-7172

## Overview

This project contains a vulnerable version of a Hospital Management System (HMS) that is susceptible to SQL Injection (CVE-2023-7172). SQL Injection is a critical web application vulnerability that can have severe impacts on the security and functionality of a system.

## CVE Details

- **CVE ID:** [CVE-2023-7172](https://nvd.nist.gov/vuln/detail/CVE-2023-7172)
- **Vulnerability Type:** SQL Injection
- **Affected Component:** Admin login page
- **Vulnerable Parameter:** username
- **Ventor Details:** [phpgurukul.com](https://phpgurukul.com/hospital-management-system-in-php/)
- **Vulnerable Version:** Hospital Management System 1.0

## Steps to Reproduce (PoC)

### Clone the Repository:

```bash
git clone https://github.com/sharathc213/CVE-2023-7172.git
cd CVE-2023-7172
```

### Run Docker Compose:

```bash
docker-compose up -d
```

### Access the Admin Login Page:

Open a web browser and navigate to the admin login page, typically located at http://localhost:8080/hms/admin/

### Initial Login Attempt:

In the "Username" field, input the following:

```
admin' -- -
```

Fill in the "Password" field with any value (it doesn't matter in this case).
![POC](https://github.com/sharathc213/CVE-2023-7172/blob/main/Screenshot_2.jpg)


### Attempt to Log In:

Click the "Log In" button to attempt to log in using the modified username.

### Observe the Result:

If the application successfully logs you into the admin dashboard without requiring the correct password, it indicates that a SQL Injection vulnerability is likely present.

## Impact of SQL Injection in a Hospital Management System

SQL Injection is a critical web application vulnerability that can have severe and wide-ranging impacts on the security and functionality of a system. Here are the key potential impacts of a successful SQL Injection attack:

- Unauthorized Data Access
- Data Exfiltration
- Data Manipulation
- Account Takeover
- System Compromise
- Application Disruption
- Legal and Compliance Consequences
- Reputation Damage
- Financial Loss

## Mitigation Recommendations

To mitigate the SQL Injection vulnerability, consider implementing the following best practices:

- Parameterized Statements (Prepared Statements)
- Stored Procedures
- Input Validation
- Whitelisting
- Escaping User Inputs


## Disclaimer

This  project is intentionally vulnerable and should only be used for educational and testing purposes. Do not deploy this in a production environment.
