import argparse
import requests
from packaging import version
from bs4 import BeautifulSoup

def check_vulnerability(url):
    readme_url = f"{url}/wp-content/plugins/seriously-simple-podcasting/readme.txt"
    try:
        response = requests.get(readme_url)
        response.raise_for_status()
        for line in response.text.splitlines():
            if line.startswith('Stable tag:'):
                plugin_version = line.split(':')[-1].strip()
                if version.parse(plugin_version) < version.parse("3.0.0"):
                    return True
                else:
                    return False
        return False
    except requests.RequestException as e:
        print(f"Error accessing {readme_url}: {e}")
        return False

def get_admin_email(url):
    feed_url = f"{url}/?feed=itunes"
    try:
        response = requests.get(feed_url)
        response.raise_for_status()
        soup = BeautifulSoup(response.content, 'xml')
        email_tag = soup.find('itunes:email')
        if email_tag:
            return email_tag.text
        else:
            print("No admin email found in the feed.")
            return None
    except requests.RequestException as e:
        print(f"Error accessing {feed_url}: {e}")
        return None

def main():
    parser = argparse.ArgumentParser(description='Check Seriously Simple Podcasting plugin version and extract admin email.')
    parser.add_argument('url', type=str, help='The URL of the WordPress site to check.')
    args = parser.parse_args()

    if check_vulnerability(args.url):
        print("Site is vulnerable!")
        email = get_admin_email(args.url)
        if email:
            print(f"Administrator email address: {email}")
        else:
            print("Could not find the administrator email address.")
    else:
        print("Site is not vulnerable!")

if __name__ == "__main__":
    main()
