#ifndef HELPERS_NFQUEUE_H
#define HELPERS_NFQUEUE_H

#include "./helpers.h"

#include <libnetfilter_queue/libnetfilter_queue.h>

/* only for NFQA_CT, not needed otherwise: */
#include <linux/netfilter/nfnetlink_conntrack.h>

#define QUEUE_NUM 2 // a random queue num

sock nlsock_queue;
uint32_t queue_socket_portid;

int setup_nf_queue();
int queue_get_id_cb(const struct nlmsghdr *nlh, void *data);
void nfq_send_verdict(int queue_num, uint32_t id, int verdict);
uint64_t queue_recv(void *cb_data);

#endif // HELPERS_NFQUEUE_H