<p align="center">
<img src="https://github.com/KevinMitchell-OSWP-CISSP/CVE-2023-52709-PoC/blob/main/CVE_2023-52709-logo.png" />
</p>

# Proof of Concept for CVE 2023-52709 "TI Bluetooth stack can fail to generate a resolvable Random Private Address (RPA) leading to DoS for already bonded peer devices"

[CVE 2023-52709](https://psirt.bosch.com/security-advisories/bosch-sa-466062.html)

## Summary
When running Defensics test case #SMP legacy 1001 with loop mode on DUT configured as resolvable private address, after a while, the device will end up generating unresolvable random private address causing Denial of Service for already bonded peer devices.

The potential vulnerability can impact Bluetooth® Low Energy devices running the affected SDK versions and enabled Bluetooth privacy with resolvable private address feature.

### The scripts in this repository (cve-2023-52709.py) simulate the attack sequence of Defensics test case  #1001 and #3

#### Important Functions
**send_pairing_request**: Sends a predefined pairing request to the specified MAC address.

**send_pairing_confirm**: Sends a predefined pairing confirm message to the specified MAC address.

**send_pairing_random**: Sends a predefined pairing random message to the specified MAC address.

**send_le_start_encryption**: Sends the "LE Start Encryption" command to the specified MAC address using the provided long-term key.

#### Example
`sudo python3 cve-2023-52709.py`
<p align="left">
<img src="https://github.com/KevinMitchell-OSWP-CISSP/CVE-2023-52709-PoC/blob/main/img.PNG"/>
</p>

#### Backgorund for context
#### Bluetooth Core Specification 5.3 Section 4.7 RESOLVING LIST
...If the Link Layer is using the Resolving List and the peer device has been resolved but the encryption fails then the current Resolvable Private Address(es) shall be immediately discarded and new Resolvable Private Address(es) shall be generated...

#### Hint: To make DOS work according to CVE 2023-52709 adjust timing of aforementioned functions, and loop. Then while connected to DUT run cve-2023-52709.py.
