# ROS2 CVE-2023-50257 Reproduction

## 🔍 Overview

This repository is based on a PoC for CVE-2023-50257 and automates the collection of RTPS packets, parses GUID values, and sends a successful DoS packet.
**CVE-2023-50257** is a known security vulnerability in ROS2 (Robot Operating System 2).
- [https://github.com/eProsima/Fast-DDS/security/advisories/GHSA-v5r6-8mvh-cp98](https://github.com/eProsima/Fast-DDS/security/advisories/GHSA-v5r6-8mvh-cp98)
- [https://github.com/Desglaneurs/BoB_Des_glaneurs/tree/main/CVE-2023-50257](https://github.com/Desglaneurs/BoB_Des_glaneurs/tree/main/CVE-2023-50257)
> ⚠️ **This project is strictly for educational and research purposes. Do not use it in production or against systems you do not own or have permission to test.**


## 🧪 Environment

- OS: Ubuntu 22.04
- ROS2 version: ros2 humble / fastdds(2.6.3) / rmw(6.2.3)

## 🚀 Getting Started

1. Build the Docker image to set up the environment:
```bash
git clone https://github.com/Jminis/CVE-2023-50257.git
docker build -t cve_2023_50257 .
docker network create ros2_net

```
2. In Terminal 1 (listener), run the following command:
```bash
docker run -it --net ros2_net --name talker cve_2023_50257
ros2 run demo_nodes_cpp talker
```

3. In Terminal 2 (talker), run the following command:
```bash
docker run -it --net ros2_net --name talker cve_2023_50257
ros2 run demo_nodes_cpp talker
```

4. In Terminal 3 (host), execute `ex.py`
```bash
pip install scapy
sudo -E python3 ex.py
```

## 📺 Demo
![DEMO](https://github.com/Jminis/CVE-2023-50257/blob/main/DEMO/TEST.gif)
