# CVE-2023-50164: Apache Struts path traversal to RCE vulnerability

A critical security vulnerability, identified as CVE-2023-50164 (CVE: 9.8) was found in Apache Struts, allowing attackers to manipulate file upload parameters that can potentially lead to unauthorized path traversal and remote code execution (RCE).

This exploit script is written for a CVE analysis on [vsociety](https://www.vicarius.io/vsociety/posts/apache-struts-rce-cve-2023-50164).

## PoC

A simple dummy app is developed for demonstration purposes (see `struts-app` folder).
You can deploy it to Tomcat or any other servlet, or run it by `mvn jetty:run`.
In this latter case you can reach the app on port `9999`.
The exploit script works only in cases when the app is deployed to Tomcat since the exploitation path is to upload a WAR webshell.
However, many other exploitation paths can work in case of the same vulnerability based on the used technologies and other circumstances.

## Usage

Deploy the exploit app to Docker:

```bash
docker container stop exploit
docker build -t exploit .
docker run -d --rm --name exploit -p 8080:8080 exploit
```

Install pip packages:

```bash
python3 -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

Then, run the exploit script:

For Docker:

```bash
python3 exploit.py --url http://localhost:8080/upload-1.0.0/upload.action
```

For Vagrant:

```bash
python3 exploit.py --url http://192.168.56.25:8080/upload-1.0.0/upload.action
```

Note that the exploit needs a full URL where the file upload functionality is implemented.

## Disclaimer

This exploit script has been created solely for the purposes of research and for the development of effective defensive techniques.
It is not intended to be used for any malicious or unauthorized activities.
The author and the owner of the script disclaim any responsibility or liability for any misuse or damage caused by this software.
Users are urged to use this software responsibly and only in accordance with applicable laws and regulations.
Use responsibly.
