# LFI Tikit eMarketing (CVE-2023-49031)
## Discovery
On November 2023, a novel local file inclusion vulnerability was identified in the “eMarketing” platform developed by Tikit (now Advanced) during a client engagement.
This issue was resolved with Advanced on February 2024

## Affected Versions 
This vulnerability has only been tested and vulnerable on version 6.8.3.0
![screenshot](/version.png)

## Attack Vector
The "filename" parameter used by "OpenLogFile" endpoint was found to be not sanitized. An unauthenticated threat actor may 
leverage this vulnerability to read arbitrary files from the local file system. 
![screenshot](/Attack_vector.png)
## POC
As a Proof-of-Concept (PoC), database credentials were collected from the "web.config" file found on a 
vulnerable machine. 
![screenshot](/POC.png)
## Vulnerability Check
An example HTTP GET payload (path + parameters) to read the hosts file on a vulnerable 
Windows system can be found below: 
* /DATA/Log/OpenLogFile?filename=C%3A%5CWindows%5CSystem32%5Cdrivers%
5Cetc%5Chosts
## Remediation
Update to the latest version of eMarketing 
