/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

public final class CharArrayWrapperSequence
implements CharSequence,
Cloneable {
    private final char[] buffer;
    private final int offset;
    private final int len;

    public CharArrayWrapperSequence(char[] array) {
        this(array, 0, array != null ? array.length : -1);
    }

    public CharArrayWrapperSequence(char[] buffer, int offset, int len) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        if (offset < 0 || offset >= buffer.length) {
            throw new IllegalArgumentException(offset + " is not a valid offset for buffer (size: " + buffer.length + ")");
        }
        if (offset + len > buffer.length) {
            throw new IllegalArgumentException(len + " is not a valid length for buffer using offset " + offset + " (size: " + buffer.length + ")");
        }
        this.buffer = buffer;
        this.offset = offset;
        this.len = len;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.len) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.buffer[index + this.offset];
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.len) {
            throw new ArrayIndexOutOfBoundsException(start);
        }
        if (end > this.len) {
            throw new ArrayIndexOutOfBoundsException(end);
        }
        return new CharArrayWrapperSequence(this.buffer, this.offset + start, end - start);
    }

    protected CharArrayWrapperSequence clone() throws CloneNotSupportedException {
        return (CharArrayWrapperSequence)super.clone();
    }

    public int hashCode() {
        if (this.len == 0) {
            return 0;
        }
        int prime = 31;
        int result = 0;
        int maxi = this.offset + this.len;
        for (int i2 = this.offset; i2 < maxi; ++i2) {
            result = 31 * result + this.buffer[i2];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CharArrayWrapperSequence) {
            CharArrayWrapperSequence other = (CharArrayWrapperSequence)obj;
            if (this.len != other.len) {
                return false;
            }
            for (int i2 = 0; i2 < this.len; ++i2) {
                if (this.buffer[i2 + this.offset] == other.buffer[i2 + other.offset]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.buffer, this.offset, this.len);
    }
}

