/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.raw;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import org.thymeleaf.templateparser.raw.IRawHandler;
import org.thymeleaf.templateparser.raw.RawParseException;

final class RawParser {
    private final BufferPool pool;

    RawParser(int poolSize, int bufferSize) {
        this.pool = new BufferPool(poolSize, bufferSize);
    }

    public void parse(String document, IRawHandler handler) throws RawParseException {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.parse(new StringReader(document), handler);
    }

    public void parse(Reader reader, IRawHandler handler) throws RawParseException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this.parseDocument(reader, this.pool.poolBufferSize, handler);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseDocument(Reader reader, int suggestedBufferSize, IRawHandler handler) throws RawParseException {
        long parsingStartTimeNanos = System.nanoTime();
        char[] buffer = null;
        try {
            boolean cont;
            handler.handleDocumentStart(parsingStartTimeNanos, 1, 1);
            int bufferSize2333332 = suggestedBufferSize;
            buffer = this.pool.allocateBuffer(bufferSize2333332);
            int bufferContentSize = reader.read(buffer);
            boolean bl = cont = bufferContentSize != -1;
            while (cont) {
                int read;
                if (bufferContentSize == bufferSize2333332) {
                    char[] newBuffer = null;
                    try {
                        newBuffer = this.pool.allocateBuffer(bufferSize2333332 *= 2);
                        System.arraycopy(buffer, 0, newBuffer, 0, bufferContentSize);
                        this.pool.releaseBuffer(buffer);
                        buffer = newBuffer;
                    }
                    catch (Exception ignored) {
                        this.pool.releaseBuffer(newBuffer);
                    }
                }
                if ((read = reader.read(buffer, bufferContentSize, bufferSize2333332 - bufferContentSize)) != -1) {
                    bufferContentSize += read;
                    continue;
                }
                cont = false;
            }
            handler.handleText(buffer, 0, bufferContentSize, 1, 1);
            int[] lastLineCol = RawParser.computeLastLineCol(buffer, bufferContentSize);
            long parsingEndTimeNanos = System.nanoTime();
            handler.handleDocumentEnd(parsingEndTimeNanos, parsingEndTimeNanos - parsingStartTimeNanos, lastLineCol[0], lastLineCol[1]);
        }
        catch (RawParseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RawParseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.pool.releaseBuffer(buffer);
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.pool.releaseBuffer(buffer);
        try {
            reader.close();
            return;
        }
        catch (Throwable bufferSize2333332) {
            return;
        }
    }

    private static int[] computeLastLineCol(char[] buffer, int bufferContentSize) {
        if (bufferContentSize == 0) {
            return new int[]{1, 1};
        }
        int line = 1;
        int col = 1;
        int lastLineFeed = 0;
        int n = bufferContentSize;
        int i2 = 0;
        while (n-- != 0) {
            char c = buffer[i2];
            if (c == '\n') {
                ++line;
                lastLineFeed = i2;
            }
            ++i2;
        }
        col = bufferContentSize - lastLineFeed;
        return new int[]{line, col};
    }

    private static final class BufferPool {
        private final char[][] pool;
        private final boolean[] allocated;
        private final int poolBufferSize;

        private BufferPool(int poolSize, int poolBufferSize) {
            this.pool = new char[poolSize][];
            this.allocated = new boolean[poolSize];
            this.poolBufferSize = poolBufferSize;
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                this.pool[i2] = new char[this.poolBufferSize];
            }
            Arrays.fill(this.allocated, false);
        }

        private synchronized char[] allocateBuffer(int bufferSize) {
            if (bufferSize != this.poolBufferSize) {
                return new char[bufferSize];
            }
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (this.allocated[i2]) continue;
                this.allocated[i2] = true;
                return this.pool[i2];
            }
            return new char[bufferSize];
        }

        private synchronized void releaseBuffer(char[] buffer) {
            if (buffer == null) {
                return;
            }
            if (buffer.length != this.poolBufferSize) {
                return;
            }
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (this.pool[i2] != buffer) continue;
                this.allocated[i2] = false;
                return;
            }
        }
    }
}

