/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.inline.NoOpInliner;
import org.thymeleaf.model.IComment;
import org.thymeleaf.processor.comment.AbstractCommentProcessor;
import org.thymeleaf.processor.comment.ICommentStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public final class StandardInliningCommentProcessor
extends AbstractCommentProcessor {
    public static final int PRECEDENCE = 1000;

    public StandardInliningCommentProcessor(TemplateMode templateMode) {
        super(templateMode, 1000);
    }

    @Override
    protected void doProcess(ITemplateContext context, IComment comment, ICommentStructureHandler structureHandler) {
        IInliner inliner = context.getInliner();
        if (inliner == null || inliner == NoOpInliner.INSTANCE) {
            return;
        }
        CharSequence inlined2 = inliner.inline(context, comment);
        if (inlined2 != null && inlined2 != comment) {
            structureHandler.setContent(inlined2);
        }
    }
}

