/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.standard.expression.TextLiteralExpression;

final class LiteralSubstitutionUtil {
    private static final char LITERAL_SUBSTITUTION_DELIMITER = '|';

    static String performLiteralSubstitution(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        boolean inLiteralSubstitution = false;
        boolean inLiteralSubstitutionInsertion = false;
        int literalSubstitutionIndex = -1;
        int expLevel = 0;
        boolean inLiteral = false;
        boolean inNothing = true;
        int inputLen = input.length();
        for (int i2 = 0; i2 < inputLen; ++i2) {
            char c = input.charAt(i2);
            if (c == '|' && !inLiteralSubstitution && inNothing) {
                if (strBuilder == null) {
                    strBuilder = new StringBuilder(inputLen + 20);
                    strBuilder.append(input, 0, i2);
                }
                inLiteralSubstitution = true;
                literalSubstitutionIndex = i2;
                continue;
            }
            if (c == '|' && inLiteralSubstitution && inNothing) {
                if (i2 - literalSubstitutionIndex == 1) {
                    strBuilder.append('|').append('|');
                } else if (inLiteralSubstitutionInsertion) {
                    strBuilder.append('\'');
                    inLiteralSubstitutionInsertion = false;
                }
                inLiteralSubstitution = false;
                literalSubstitutionIndex = -1;
                continue;
            }
            if (inNothing && (c == '$' || c == '*' || c == '#' || c == '@') && i2 + 1 < inputLen && input.charAt(i2 + 1) == '{') {
                if (inLiteralSubstitution && inLiteralSubstitutionInsertion) {
                    strBuilder.append("' + ");
                    inLiteralSubstitutionInsertion = false;
                } else if (inLiteralSubstitution && i2 > 0 && input.charAt(i2 - 1) == '}') {
                    strBuilder.append(" + '' + ");
                }
                if (strBuilder != null) {
                    strBuilder.append(c);
                    strBuilder.append('{');
                }
                expLevel = 1;
                ++i2;
                inNothing = false;
                continue;
            }
            if (expLevel == 1 && c == '}') {
                if (strBuilder != null) {
                    strBuilder.append('}');
                }
                expLevel = 0;
                inNothing = true;
                continue;
            }
            if (expLevel > 0 && c == '{') {
                if (strBuilder != null) {
                    strBuilder.append('{');
                }
                ++expLevel;
                continue;
            }
            if (expLevel > 1 && c == '}') {
                if (strBuilder != null) {
                    strBuilder.append('}');
                }
                --expLevel;
                continue;
            }
            if (expLevel > 0) {
                if (strBuilder == null) continue;
                strBuilder.append(c);
                continue;
            }
            if (inNothing && !inLiteralSubstitution && c == '\'' && !TextLiteralExpression.isDelimiterEscaped(input, i2)) {
                inNothing = false;
                inLiteral = true;
                if (strBuilder == null) continue;
                strBuilder.append(c);
                continue;
            }
            if (inLiteral && !inLiteralSubstitution && c == '\'' && !TextLiteralExpression.isDelimiterEscaped(input, i2)) {
                inLiteral = false;
                inNothing = true;
                if (strBuilder == null) continue;
                strBuilder.append(c);
                continue;
            }
            if (inLiteralSubstitution && inNothing) {
                if (!inLiteralSubstitutionInsertion) {
                    if (input.charAt(i2 - 1) != '|') {
                        strBuilder.append(" + ");
                    }
                    strBuilder.append('\'');
                    inLiteralSubstitutionInsertion = true;
                }
                if (c == '\'') {
                    strBuilder.append('\\');
                } else if (c == '\\') {
                    strBuilder.append('\\');
                }
                strBuilder.append(c);
                continue;
            }
            if (strBuilder == null) continue;
            strBuilder.append(c);
        }
        if (strBuilder == null) {
            return input;
        }
        return strBuilder.toString();
    }

    private LiteralSubstitutionUtil() {
    }
}

