/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.view;

import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.WebExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.context.webmvc.SpringWebMvcThymeleafRequestContext;
import org.thymeleaf.spring5.expression.ThymeleafEvaluationContext;
import org.thymeleaf.spring5.util.SpringContentTypeUtils;
import org.thymeleaf.spring5.util.SpringRequestUtils;
import org.thymeleaf.spring5.view.AbstractThymeleafView;
import org.thymeleaf.standard.expression.FragmentExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.FastStringWriter;

public class ThymeleafView
extends AbstractThymeleafView {
    private static final String pathVariablesSelector;
    private Set<String> markupSelectors = null;

    public ThymeleafView() {
    }

    public ThymeleafView(String templateName) {
        super(templateName);
    }

    public String getMarkupSelector() {
        return this.markupSelectors == null || this.markupSelectors.size() == 0 ? null : this.markupSelectors.iterator().next();
    }

    public void setMarkupSelector(String markupSelector) {
        this.markupSelectors = markupSelector == null || markupSelector.trim().length() == 0 ? null : Collections.singleton(markupSelector.trim());
    }

    @Override
    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.renderFragment(this.markupSelectors, model, request, response);
    }

    protected void renderFragment(Set<String> markupSelectorsToRender, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set<String> processMarkupSelectors;
        Set<String> markupSelectors;
        String templateName;
        Map pathVars;
        ServletContext servletContext = this.getServletContext();
        String viewTemplateName = this.getTemplateName();
        ISpringTemplateEngine viewTemplateEngine = this.getTemplateEngine();
        if (viewTemplateName == null) {
            throw new IllegalArgumentException("Property 'templateName' is required");
        }
        if (this.getLocale() == null) {
            throw new IllegalArgumentException("Property 'locale' is required");
        }
        if (viewTemplateEngine == null) {
            throw new IllegalArgumentException("Property 'templateEngine' is required");
        }
        HashMap<String, Object> mergedModel = new HashMap<String, Object>(30);
        Map<String, Object> templateStaticVariables = this.getStaticVariables();
        if (templateStaticVariables != null) {
            mergedModel.putAll(templateStaticVariables);
        }
        if (pathVariablesSelector != null && (pathVars = (Map)request.getAttribute(pathVariablesSelector)) != null) {
            mergedModel.putAll(pathVars);
        }
        if (model != null) {
            mergedModel.putAll(model);
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        RequestContext requestContext = new RequestContext(request, response, this.getServletContext(), mergedModel);
        SpringWebMvcThymeleafRequestContext thymeleafRequestContext = new SpringWebMvcThymeleafRequestContext(requestContext, request);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springRequestContext", requestContext);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springMacroRequestContext", requestContext);
        mergedModel.put("thymeleafRequestContext", thymeleafRequestContext);
        ConversionService conversionService = (ConversionService)request.getAttribute(ConversionService.class.getName());
        ThymeleafEvaluationContext evaluationContext = new ThymeleafEvaluationContext(applicationContext, conversionService);
        mergedModel.put("thymeleaf::EvaluationContext", evaluationContext);
        IEngineConfiguration configuration = viewTemplateEngine.getConfiguration();
        WebExpressionContext context = new WebExpressionContext(configuration, request, response, servletContext, this.getLocale(), mergedModel);
        if (!viewTemplateName.contains("::")) {
            templateName = viewTemplateName;
            markupSelectors = null;
        } else {
            FragmentExpression fragmentExpression;
            SpringRequestUtils.checkViewNameNotInRequest(viewTemplateName, request);
            IStandardExpressionParser parser = StandardExpressions.getExpressionParser(configuration);
            try {
                fragmentExpression = (FragmentExpression)parser.parseExpression(context, "~{" + viewTemplateName + "}");
            }
            catch (TemplateProcessingException e) {
                throw new IllegalArgumentException("Invalid template name specification: '" + viewTemplateName + "'");
            }
            FragmentExpression.ExecutedFragmentExpression fragment = FragmentExpression.createExecutedFragmentExpression(context, fragmentExpression);
            templateName = FragmentExpression.resolveTemplateName(fragment);
            markupSelectors = FragmentExpression.resolveFragments(fragment);
            Map<String, Object> nameFragmentParameters = fragment.getFragmentParameters();
            if (nameFragmentParameters != null) {
                if (fragment.hasSyntheticParameters()) {
                    throw new IllegalArgumentException("Parameters in a view specification must be named (non-synthetic): '" + viewTemplateName + "'");
                }
                context.setVariables(nameFragmentParameters);
            }
        }
        String templateContentType = this.getContentType();
        Locale templateLocale = this.getLocale();
        String templateCharacterEncoding = this.getCharacterEncoding();
        if (markupSelectors != null && markupSelectors.size() > 0) {
            if (markupSelectorsToRender != null && markupSelectorsToRender.size() > 0) {
                throw new IllegalArgumentException("A markup selector has been specified (" + Arrays.asList(markupSelectors) + ") for a view that was already being executed as a fragment (" + Arrays.asList(markupSelectorsToRender) + "). Only one fragment selection is allowed.");
            }
            processMarkupSelectors = markupSelectors;
        } else {
            processMarkupSelectors = markupSelectorsToRender != null && markupSelectorsToRender.size() > 0 ? markupSelectorsToRender : null;
        }
        response.setLocale(templateLocale);
        if (!this.getForceContentType()) {
            String computedContentType = SpringContentTypeUtils.computeViewContentType(request, templateContentType != null ? templateContentType : "text/html;charset=ISO-8859-1", templateCharacterEncoding != null ? Charset.forName(templateCharacterEncoding) : null);
            response.setContentType(computedContentType);
        } else {
            if (templateContentType != null) {
                response.setContentType(templateContentType);
            } else {
                response.setContentType("text/html;charset=ISO-8859-1");
            }
            if (templateCharacterEncoding != null) {
                response.setCharacterEncoding(templateCharacterEncoding);
            }
        }
        boolean producePartialOutputWhileProcessing = this.getProducePartialOutputWhileProcessing();
        Writer templateWriter = producePartialOutputWhileProcessing ? response.getWriter() : new FastStringWriter(1024);
        viewTemplateEngine.process(templateName, processMarkupSelectors, context, templateWriter);
        if (!producePartialOutputWhileProcessing) {
            response.getWriter().write(templateWriter.toString());
            response.getWriter().flush();
        }
    }

    static {
        String pathVariablesSelectorValue = null;
        try {
            Field pathVariablesField = View.class.getDeclaredField("PATH_VARIABLES");
            pathVariablesSelectorValue = (String)pathVariablesField.get(null);
        }
        catch (NoSuchFieldException ignored) {
            pathVariablesSelectorValue = null;
        }
        catch (IllegalAccessException ignored) {
            pathVariablesSelectorValue = null;
        }
        pathVariablesSelector = pathVariablesSelectorValue;
    }
}

