/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.util;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.StringUtils;
import org.unbescape.uri.UriEscape;

public final class SpringRequestUtils {
    public static void checkViewNameNotInRequest(String viewName, HttpServletRequest request) {
        String vn = StringUtils.pack(viewName);
        if (!SpringRequestUtils.containsExpression(vn)) {
            return;
        }
        boolean found = false;
        String requestURI = StringUtils.pack(UriEscape.unescapeUriPath(request.getRequestURI()));
        if (requestURI != null && SpringRequestUtils.containsExpression(requestURI)) {
            found = true;
        }
        if (!found) {
            Enumeration paramNames = request.getParameterNames();
            while (!found && paramNames.hasMoreElements()) {
                String[] paramValues = request.getParameterValues((String)paramNames.nextElement());
                for (int i2 = 0; !found && i2 < paramValues.length; ++i2) {
                    String paramValue = StringUtils.pack(paramValues[i2]);
                    if (paramValue == null || !SpringRequestUtils.containsExpression(paramValue) || !vn.contains(paramValue)) continue;
                    found = true;
                }
            }
        }
        if (found) {
            throw new TemplateProcessingException("View name contains an expression and so does either the URL path or one of the request parameters. This is forbidden in order to reduce the possibilities that direct user input is executed as a part of the view name.");
        }
    }

    private static boolean containsExpression(String text) {
        int textLen = text.length();
        boolean expInit = false;
        for (int i2 = 0; i2 < textLen; ++i2) {
            char c = text.charAt(i2);
            if (!expInit) {
                if (c != '$' && c != '*' && c != '#' && c != '@' && c != '~') continue;
                expInit = true;
                continue;
            }
            if (c == '{') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            expInit = false;
        }
        return false;
    }

    private SpringRequestUtils() {
    }
}

