/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.templateresource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class SpringResourceTemplateResource
implements ITemplateResource {
    private final Resource resource;
    private final String characterEncoding;

    public SpringResourceTemplateResource(ApplicationContext applicationContext, String location, String characterEncoding) {
        Validate.notNull(applicationContext, "Application Context cannot be null");
        Validate.notEmpty(location, "Resource Location cannot be null or empty");
        this.resource = applicationContext.getResource(location);
        this.characterEncoding = characterEncoding;
    }

    public SpringResourceTemplateResource(Resource resource, String characterEncoding) {
        Validate.notNull(resource, "Resource cannot be null");
        this.resource = resource;
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getDescription() {
        return this.resource.getDescription();
    }

    @Override
    public String getBaseName() {
        return SpringResourceTemplateResource.computeBaseName(this.resource.getFilename());
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public Reader reader() throws IOException {
        InputStream inputStream = this.resource.getInputStream();
        if (!StringUtils.isEmptyOrWhitespace(this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        Resource relativeResource;
        try {
            relativeResource = this.resource.createRelative(relativeLocation);
        }
        catch (IOException e) {
            return new SpringResourceInvalidRelativeTemplateResource(this.getDescription(), relativeLocation, e);
        }
        return new SpringResourceTemplateResource(relativeResource, this.characterEncoding);
    }

    static String computeBaseName(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        String basePath = path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
        int slashPos = basePath.lastIndexOf(47);
        if (slashPos != -1) {
            int dotPos = basePath.lastIndexOf(46);
            if (dotPos != -1 && dotPos > slashPos + 1) {
                return basePath.substring(slashPos + 1, dotPos);
            }
            return basePath.substring(slashPos + 1);
        }
        int dotPos = basePath.lastIndexOf(46);
        if (dotPos != -1) {
            return basePath.substring(0, dotPos);
        }
        return basePath.length() > 0 ? basePath : null;
    }

    private static final class SpringResourceInvalidRelativeTemplateResource
    implements ITemplateResource {
        private final String originalResourceDescription;
        private final String relativeLocation;
        private final IOException ioException;

        SpringResourceInvalidRelativeTemplateResource(String originalResourceDescription, String relativeLocation, IOException ioException) {
            this.originalResourceDescription = originalResourceDescription;
            this.relativeLocation = relativeLocation;
            this.ioException = ioException;
        }

        @Override
        public String getDescription() {
            return "Invalid relative resource for relative location \"" + this.relativeLocation + "\" and original resource " + this.originalResourceDescription + ": " + this.ioException.getMessage();
        }

        @Override
        public String getBaseName() {
            return "Invalid relative resource for relative location \"" + this.relativeLocation + "\" and original resource " + this.originalResourceDescription + ": " + this.ioException.getMessage();
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public Reader reader() throws IOException {
            throw new IOException("Invalid relative resource", this.ioException);
        }

        @Override
        public ITemplateResource relative(String relativeLocation) {
            return this;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

