/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring5.context.IThymeleafBindStatus;
import org.thymeleaf.spring5.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring5.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.spring5.util.SpringSelectedValueComparator;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringInputRadioFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public static final String RADIO_INPUT_TYPE_ATTR_VALUE = "radio";

    public SpringInputRadioFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "input", "type", new String[]{RADIO_INPUT_TYPE_ATTR_VALUE}, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IThymeleafBindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, true);
        String value = tag.getAttributeValue(this.valueAttributeDefinition.getAttributeName());
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"input(radio)\" tags");
        }
        boolean checked = SpringSelectedValueComparator.isSelected(bindStatus, HtmlEscape.unescapeHtml(value));
        StandardProcessorUtils.setAttribute(structureHandler, this.idAttributeDefinition, "id", id);
        StandardProcessorUtils.setAttribute(structureHandler, this.nameAttributeDefinition, "name", name);
        StandardProcessorUtils.setAttribute(structureHandler, this.valueAttributeDefinition, "value", RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, RADIO_INPUT_TYPE_ATTR_VALUE));
        if (checked) {
            StandardProcessorUtils.setAttribute(structureHandler, this.checkedAttributeDefinition, "checked", "checked");
        } else {
            structureHandler.removeAttribute(this.checkedAttributeDefinition.getAttributeName());
        }
    }
}

