/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring5.context.IThymeleafBindStatus;
import org.thymeleaf.spring5.util.FieldUtils;
import org.thymeleaf.spring5.util.SpringValueFormatter;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public final class SpringErrorsTagProcessor
extends AbstractAttributeTagProcessor {
    private static final String ERROR_DELIMITER = "<br />";
    public static final int ATTR_PRECEDENCE = 1700;
    public static final String ATTR_NAME = "errors";

    public SpringErrorsTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 1700, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        IThymeleafBindStatus bindStatus = FieldUtils.getBindStatus(context, attributeValue);
        if (bindStatus.isError()) {
            StringBuilder strBuilder = new StringBuilder();
            String[] errorMsgs = bindStatus.getErrorMessages();
            for (int i2 = 0; i2 < errorMsgs.length; ++i2) {
                if (i2 > 0) {
                    strBuilder.append(ERROR_DELIMITER);
                }
                String displayString = SpringValueFormatter.getDisplayString(errorMsgs[i2], false);
                strBuilder.append(HtmlEscape.escapeHtml4Xml(displayString));
            }
            structureHandler.setBody(strBuilder.toString(), false);
            structureHandler.setLocalVariable("thymeleafFieldBindStatus", bindStatus);
        } else {
            structureHandler.removeElement();
        }
    }
}

