/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.expression;

import java.util.Collections;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring5.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring5.expression.SPELContextPropertyAccessor;
import org.thymeleaf.standard.expression.RestrictedRequestAccessUtils;
import org.thymeleaf.util.ExpressionUtils;
import org.thymeleaf.util.Validate;

public final class ThymeleafEvaluationContext
extends StandardEvaluationContext
implements IThymeleafEvaluationContext {
    public static final String THYMELEAF_EVALUATION_CONTEXT_CONTEXT_VARIABLE_NAME = "thymeleaf::EvaluationContext";
    private static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();
    private static final TypeLocator TYPE_LOCATOR = new ThymeleafEvaluationContextACLTypeLocator();
    private static final List<MethodResolver> METHOD_RESOLVERS = Collections.singletonList(new ThymeleafEvaluationContextACLMethodResolver());
    private final ApplicationContext applicationContext;
    private IExpressionObjects expressionObjects = null;
    private boolean variableAccessRestricted = false;

    public ThymeleafEvaluationContext(ApplicationContext applicationContext, ConversionService conversionService) {
        Validate.notNull(applicationContext, "Application Context cannot be null");
        this.applicationContext = applicationContext;
        this.setBeanResolver(new BeanFactoryResolver(applicationContext));
        if (conversionService != null) {
            this.setTypeConverter(new StandardTypeConverter(conversionService));
        }
        this.addPropertyAccessor(SPELContextPropertyAccessor.INSTANCE);
        this.addPropertyAccessor(MAP_ACCESSOR_INSTANCE);
        this.setTypeLocator(TYPE_LOCATOR);
        this.setMethodResolvers(METHOD_RESOLVERS);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Object lookupVariable(String name) {
        Object result;
        if (this.expressionObjects != null && this.expressionObjects.containsObject(name) && (result = this.expressionObjects.getObject(name)) != null) {
            if (this.variableAccessRestricted && ("request".equals(name) || "httpServletRequest".equals(name))) {
                return RestrictedRequestAccessUtils.wrapRequestObject(result);
            }
            return result;
        }
        return super.lookupVariable(name);
    }

    @Override
    public boolean isVariableAccessRestricted() {
        return this.variableAccessRestricted;
    }

    @Override
    public void setVariableAccessRestricted(boolean restricted) {
        this.variableAccessRestricted = restricted;
    }

    @Override
    public IExpressionObjects getExpressionObjects() {
        return this.expressionObjects;
    }

    @Override
    public void setExpressionObjects(IExpressionObjects expressionObjects) {
        this.expressionObjects = expressionObjects;
    }

    static final class ThymeleafEvaluationContextACLMethodResolver
    extends ReflectiveMethodResolver {
        ThymeleafEvaluationContextACLMethodResolver() {
        }

        @Override
        public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
            Class<?> type;
            Class<?> clazz = type = targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass();
            if (!(ExpressionUtils.isTypeAllowed(type.getName()) || Class.class.equals(type) && "getName".equals(name) || Object.class.equals(type) && "getClass".equals(name))) {
                throw new EvaluationException(String.format("Calling methods is forbidden for type '%s' in Thymeleaf expressions. Blacklisted classes are: %s.", type.getName(), ExpressionUtils.getBlacklist()));
            }
            return super.resolve(context, targetObject, name, argumentTypes);
        }
    }

    static final class ThymeleafEvaluationContextACLTypeLocator
    implements TypeLocator {
        private final StandardTypeLocator typeLocator = new StandardTypeLocator();

        ThymeleafEvaluationContextACLTypeLocator() {
            this.typeLocator.removeImport("java.lang");
        }

        @Override
        public Class<?> findType(String typeName) throws EvaluationException {
            if (typeName != null && !ExpressionUtils.isTypeAllowed(typeName)) {
                throw new EvaluationException(String.format("Access is forbidden for type '%s' in Thymeleaf expressions. Blacklisted classes are: %s.", typeName, ExpressionUtils.getBlacklist()));
            }
            return this.typeLocator.findType(typeName);
        }
    }
}

