/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webflux;

import java.util.Locale;
import java.util.Map;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.spring5.context.webflux.ISpringWebFluxContext;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Mono;

public class SpringWebFluxContext
extends AbstractContext
implements ISpringWebFluxContext {
    private final ServerWebExchange exchange;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public SpringWebFluxContext(ServerWebExchange exchange2) {
        this(exchange2, null, null, null);
    }

    public SpringWebFluxContext(ServerWebExchange exchange2, Locale locale) {
        this(exchange2, null, locale, null);
    }

    public SpringWebFluxContext(ServerWebExchange exchange2, Locale locale, Map<String, Object> variables) {
        this(exchange2, null, locale, variables);
    }

    public SpringWebFluxContext(ServerWebExchange exchange2, ReactiveAdapterRegistry reactiveAdapterRegistry, Locale locale, Map<String, Object> variables) {
        super(locale, variables);
        Validate.notNull(exchange2, "ServerWebExchange cannot be null in Spring WebFlux contexts");
        this.exchange = exchange2;
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    @Override
    public ServerHttpRequest getRequest() {
        return this.exchange.getRequest();
    }

    @Override
    public Mono<WebSession> getSession() {
        return this.exchange.getSession();
    }

    @Override
    public ServerHttpResponse getResponse() {
        return this.exchange.getResponse();
    }

    @Override
    public ServerWebExchange getExchange() {
        return this.exchange;
    }
}

