/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5;

import java.util.Set;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.dialect.SpringStandardDialect;
import org.thymeleaf.spring5.messageresolver.SpringMessageResolver;

public class SpringTemplateEngine
extends TemplateEngine
implements ISpringTemplateEngine,
MessageSourceAware {
    private static final SpringStandardDialect SPRINGSTANDARD_DIALECT = new SpringStandardDialect();
    private MessageSource messageSource = null;
    private MessageSource templateEngineMessageSource = null;

    public SpringTemplateEngine() {
        super.setDialect(SPRINGSTANDARD_DIALECT);
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public void setTemplateEngineMessageSource(MessageSource templateEngineMessageSource) {
        this.templateEngineMessageSource = templateEngineMessageSource;
    }

    public boolean getEnableSpringELCompiler() {
        Set<IDialect> dialects = this.getDialects();
        for (IDialect dialect : dialects) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            return ((SpringStandardDialect)dialect).getEnableSpringELCompiler();
        }
        return false;
    }

    public void setEnableSpringELCompiler(boolean enableSpringELCompiler) {
        Set<IDialect> dialects = this.getDialects();
        for (IDialect dialect : dialects) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            ((SpringStandardDialect)dialect).setEnableSpringELCompiler(enableSpringELCompiler);
        }
    }

    public boolean getRenderHiddenMarkersBeforeCheckboxes() {
        Set<IDialect> dialects = this.getDialects();
        for (IDialect dialect : dialects) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            return ((SpringStandardDialect)dialect).getRenderHiddenMarkersBeforeCheckboxes();
        }
        return false;
    }

    public void setRenderHiddenMarkersBeforeCheckboxes(boolean renderHiddenMarkersBeforeCheckboxes) {
        Set<IDialect> dialects = this.getDialects();
        for (IDialect dialect : dialects) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            ((SpringStandardDialect)dialect).setRenderHiddenMarkersBeforeCheckboxes(renderHiddenMarkersBeforeCheckboxes);
        }
    }

    @Override
    protected final void initializeSpecific() {
        AbstractMessageResolver messageResolver;
        MessageSource messageSource;
        this.initializeSpringSpecific();
        super.initializeSpecific();
        MessageSource messageSource2 = messageSource = this.templateEngineMessageSource == null ? this.messageSource : this.templateEngineMessageSource;
        if (messageSource != null) {
            SpringMessageResolver springMessageResolver = new SpringMessageResolver();
            springMessageResolver.setMessageSource(messageSource);
            messageResolver = springMessageResolver;
        } else {
            messageResolver = new StandardMessageResolver();
        }
        super.setMessageResolver(messageResolver);
    }

    protected void initializeSpringSpecific() {
    }
}

