/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.java8time.util;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.thymeleaf.extras.java8time.util.TemporalFormattingUtils;
import org.thymeleaf.util.Validate;

public final class TemporalSetUtils {
    private final TemporalFormattingUtils temporalFormattingUtils;

    public TemporalSetUtils(Locale locale, ZoneId defaultZoneId) {
        Validate.notNull(locale, "Locale cannot be null");
        Validate.notNull(defaultZoneId, "ZoneId cannot be null");
        this.temporalFormattingUtils = new TemporalFormattingUtils(locale, defaultZoneId);
    }

    public Set<String> setFormat(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::format);
    }

    public <T extends Temporal> Set<String> setFormat(Set<T> target, Locale locale) {
        return this.setFormat(target, (T time) -> this.temporalFormattingUtils.format(time, locale));
    }

    public <T extends Temporal> Set<String> setFormat(Set<T> target, String pattern) {
        return this.setFormat(target, (T time) -> this.temporalFormattingUtils.format(time, pattern));
    }

    public <T extends Temporal> Set<String> setFormat(Set<T> target, String pattern, Locale locale) {
        return this.setFormat(target, (T time) -> this.temporalFormattingUtils.format(time, pattern, locale));
    }

    public Set<Integer> setDay(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::day);
    }

    public Set<Integer> setMonth(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::month);
    }

    public Set<String> setMonthName(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::monthName);
    }

    public Set<String> setMonthNameShort(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::monthNameShort);
    }

    public Set<Integer> setYear(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::year);
    }

    public Set<Integer> setDayOfWeek(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::dayOfWeek);
    }

    public Set<String> setDayOfWeekName(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::dayOfWeekName);
    }

    public Set<String> setDayOfWeekNameShort(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::dayOfWeekNameShort);
    }

    public Set<Integer> setHour(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::hour);
    }

    public Set<Integer> setMinute(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::minute);
    }

    public Set<Integer> setSecond(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::second);
    }

    public Set<Integer> setNanosecond(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::nanosecond);
    }

    public Set<String> setFormatISO(Set<? extends Temporal> target) {
        return this.setFormat(target, this.temporalFormattingUtils::formatISO);
    }

    private <R, T extends Temporal> Set<R> setFormat(Set<T> target, Function<T, R> mapFunction) {
        Validate.notNull(target, "Target cannot be null");
        return target.stream().map(time -> mapFunction.apply(time)).collect(Collectors.toSet());
    }
}

