/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.java8time.util;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.thymeleaf.extras.java8time.util.TemporalFormattingUtils;
import org.thymeleaf.util.Validate;

public final class TemporalListUtils {
    private final TemporalFormattingUtils temporalFormattingUtils;

    public TemporalListUtils(Locale locale, ZoneId defaultZoneId) {
        Validate.notNull(locale, "Locale cannot be null");
        Validate.notNull(defaultZoneId, "ZoneId cannot be null");
        this.temporalFormattingUtils = new TemporalFormattingUtils(locale, defaultZoneId);
    }

    public List<String> listFormat(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::format);
    }

    public <T extends Temporal> List<String> listFormat(List<T> target, Locale locale) {
        return this.listFormat(target, (T time) -> this.temporalFormattingUtils.format(time, locale));
    }

    public <T extends Temporal> List<String> listFormat(List<T> target, String pattern) {
        return this.listFormat(target, (T time) -> this.temporalFormattingUtils.format(time, pattern));
    }

    public <T extends Temporal> List<String> listFormat(List<T> target, String pattern, Locale locale) {
        return this.listFormat(target, (T time) -> this.temporalFormattingUtils.format(time, pattern, locale));
    }

    public List<Integer> listDay(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::day);
    }

    public List<Integer> listMonth(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::month);
    }

    public List<String> listMonthName(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::monthName);
    }

    public List<String> listMonthNameShort(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::monthNameShort);
    }

    public List<Integer> listYear(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::year);
    }

    public List<Integer> listDayOfWeek(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::dayOfWeek);
    }

    public List<String> listDayOfWeekName(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::dayOfWeekName);
    }

    public List<String> listDayOfWeekNameShort(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::dayOfWeekNameShort);
    }

    public List<Integer> listHour(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::hour);
    }

    public List<Integer> listMinute(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::minute);
    }

    public List<Integer> listSecond(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::second);
    }

    public List<Integer> listNanosecond(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::nanosecond);
    }

    public List<String> listFormatISO(List<? extends Temporal> target) {
        return this.listFormat(target, this.temporalFormattingUtils::formatISO);
    }

    private <R, T extends Temporal> List<R> listFormat(List<T> target, Function<T, R> mapFunction) {
        Validate.notNull(target, "Target cannot be null");
        return target.stream().map(time -> mapFunction.apply(time)).collect(Collectors.toList());
    }
}

