/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

public final class Objects {
    public <T> T nullSafe(T target, T defaultValue) {
        return ObjectUtils.nullSafe(target, defaultValue);
    }

    public <T> T[] arrayNullSafe(T[] target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        Object[] result = (Object[])target.clone();
        for (int i2 = 0; i2 < target.length; ++i2) {
            result[i2] = this.nullSafe(target[i2], defaultValue);
        }
        return result;
    }

    public <T> List<T> listNullSafe(List<T> target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<T> result = new ArrayList<T>(target.size() + 2);
        for (T element : target) {
            result.add(this.nullSafe(element, defaultValue));
        }
        return result;
    }

    public <T> Set<T> setNullSafe(Set<T> target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<T> result = new LinkedHashSet<T>(target.size() + 2);
        for (T element : target) {
            result.add(this.nullSafe(element, defaultValue));
        }
        return result;
    }
}

