/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import org.thymeleaf.engine.ISSEThrottledTemplateWriterControl;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.ThrottledTemplateWriter;

class SSEThrottledTemplateWriter
extends ThrottledTemplateWriter
implements ISSEThrottledTemplateWriterControl {
    private static final char[] SSE_ID_PREFIX = "id: ".toCharArray();
    private static final char[] SSE_EVENT_PREFIX = "event: ".toCharArray();
    private static final char[] SSE_DATA_PREFIX = "data: ".toCharArray();
    private char[] id = null;
    private char[] event = null;
    private boolean eventHasMeta = false;
    private boolean newEvent = true;

    SSEThrottledTemplateWriter(String templateName, TemplateFlowController flowController) {
        super(templateName, flowController);
    }

    @Override
    public void startEvent(char[] id, char[] event) {
        this.newEvent = true;
        this.id = id;
        this.event = event;
    }

    private void doStartEvent() throws IOException {
        this.eventHasMeta = false;
        if (this.event != null) {
            if (!SSEThrottledTemplateWriter.checkTokenValid(this.event)) {
                throw new IllegalArgumentException("Event for SSE event cannot contain a newline (\\n) character");
            }
            super.write(SSE_EVENT_PREFIX);
            super.write(this.event);
            super.write(10);
            this.eventHasMeta = true;
        }
        if (this.id != null) {
            if (!SSEThrottledTemplateWriter.checkTokenValid(this.id)) {
                throw new IllegalArgumentException("ID for SSE event cannot contain a newline (\\n) character");
            }
            super.write(SSE_ID_PREFIX);
            super.write(this.id);
            super.write(10);
            this.eventHasMeta = true;
        }
    }

    @Override
    public void endEvent() throws IOException {
        if (!this.newEvent) {
            super.write(10);
            super.write(10);
        } else if (this.eventHasMeta) {
            super.write(10);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.newEvent) {
            this.doStartEvent();
            super.write(SSE_DATA_PREFIX);
            this.newEvent = false;
        }
        super.write(c);
        if (c == 10) {
            super.write(SSE_DATA_PREFIX);
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int i2;
        if (str == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > str.length() || len < 0 || off + len > str.length() || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            super.write(str, off, len);
            return;
        }
        if (this.newEvent) {
            this.doStartEvent();
            super.write(SSE_DATA_PREFIX);
            this.newEvent = false;
        }
        int x = i2 = off;
        int maxi = off + len;
        while (i2 < maxi) {
            char c;
            if ((c = str.charAt(i2++)) != '\n') continue;
            super.write(str, x, i2 - x);
            super.write(SSE_DATA_PREFIX);
            x = i2;
        }
        if (x < i2) {
            super.write(str, x, i2 - x);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int i2;
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            super.write(cbuf, off, len);
            return;
        }
        if (this.newEvent) {
            this.doStartEvent();
            super.write(SSE_DATA_PREFIX);
            this.newEvent = false;
        }
        int x = i2 = off;
        int maxi = off + len;
        while (i2 < maxi) {
            char c;
            if ((c = cbuf[i2++]) != '\n') continue;
            super.write(cbuf, x, i2 - x);
            super.write(SSE_DATA_PREFIX);
            x = i2;
        }
        if (x < i2) {
            super.write(cbuf, x, i2 - x);
        }
    }

    private static boolean checkTokenValid(char[] token) {
        if (token == null || token.length == 0) {
            return true;
        }
        for (int i2 = 0; i2 < token.length; ++i2) {
            if (token[i2] != '\n') continue;
            return false;
        }
        return true;
    }
}

