/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.engine.AbstractGatheringModelProcessable;
import org.thymeleaf.engine.CloseElementTag;
import org.thymeleaf.engine.DataDrivenTemplateIterator;
import org.thymeleaf.engine.IterationStatusVar;
import org.thymeleaf.engine.Model;
import org.thymeleaf.engine.OpenElementTag;
import org.thymeleaf.engine.ProcessorExecutionVars;
import org.thymeleaf.engine.ProcessorTemplateHandler;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.TemplateModelController;
import org.thymeleaf.engine.Text;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;

final class IteratedGatheringModelProcessable
extends AbstractGatheringModelProcessable {
    private static final String DEFAULT_STATUS_VAR_SUFFIX = "Stat";
    private final IEngineContext context;
    private final TemplateMode templateMode;
    private final String iterVariableName;
    private final String iterStatusVariableName;
    private final IterationStatusVar iterStatusVariable;
    private final Iterator<?> iterator;
    private final Text precedingWhitespace;
    private IterationModels iterationModels;
    private DataDrivenTemplateIterator dataDrivenIterator;
    private int iter;
    private int iterOffset;
    private Model iterModel;

    IteratedGatheringModelProcessable(IEngineConfiguration configuration, ProcessorTemplateHandler processorTemplateHandler, IEngineContext context, TemplateModelController modelController, TemplateFlowController flowController, TemplateModelController.SkipBody gatheredSkipBody, boolean gatheredSkipCloseTag, ProcessorExecutionVars processorExecutionVars, String iterVariableName, String iterStatusVariableName, Object iteratedObject, Text precedingWhitespace) {
        super(configuration, processorTemplateHandler, context, modelController, flowController, gatheredSkipBody, gatheredSkipCloseTag, processorExecutionVars);
        this.context = context;
        this.templateMode = context.getTemplateMode();
        this.iterator = IteratedGatheringModelProcessable.computeIteratedObjectIterator(iteratedObject);
        this.iterVariableName = iterVariableName;
        this.iterStatusVariableName = StringUtils.isEmptyOrWhitespace(iterStatusVariableName) ? iterVariableName + DEFAULT_STATUS_VAR_SUFFIX : iterStatusVariableName;
        this.iterStatusVariable = new IterationStatusVar();
        this.iterStatusVariable.index = 0;
        this.iterStatusVariable.size = IteratedGatheringModelProcessable.computeIteratedObjectSize(iteratedObject);
        this.precedingWhitespace = precedingWhitespace;
        this.dataDrivenIterator = this.iterator != null && this.iterator instanceof DataDrivenTemplateIterator ? (DataDrivenTemplateIterator)this.iterator : null;
        this.iter = 0;
        this.iterOffset = 0;
        this.iterModel = null;
    }

    @Override
    public ProcessorExecutionVars initializeProcessorExecutionVars() {
        return super.initializeProcessorExecutionVars().cloneVars();
    }

    @Override
    public boolean process() {
        TemplateFlowController flowController = this.getFlowController();
        if (flowController != null && flowController.stopProcessing) {
            return false;
        }
        if (this.iterModel == null && flowController != null && this.dataDrivenIterator != null && this.dataDrivenIterator.isPaused()) {
            flowController.stopProcessing = true;
            return false;
        }
        if (this.iterationModels == null) {
            IterationWhiteSpaceHandling iterationWhiteSpaceHandling;
            if (this.dataDrivenIterator != null) {
                if (this.iterator.hasNext()) {
                    iterationWhiteSpaceHandling = IterationWhiteSpaceHandling.SINGLE_ITER;
                    this.iterStatusVariable.current = this.iterator.next();
                } else {
                    iterationWhiteSpaceHandling = IterationWhiteSpaceHandling.ZERO_ITER;
                }
            } else if (this.iterator.hasNext()) {
                this.iterStatusVariable.current = this.iterator.next();
                iterationWhiteSpaceHandling = this.iterator.hasNext() ? IterationWhiteSpaceHandling.MULTIPLE_ITER : IterationWhiteSpaceHandling.SINGLE_ITER;
            } else {
                iterationWhiteSpaceHandling = IterationWhiteSpaceHandling.ZERO_ITER;
            }
            this.iterationModels = this.computeIterationModels(iterationWhiteSpaceHandling);
        }
        if (this.iter == 0) {
            if (!this.iterationModels.isEmpty()) {
                boolean iterationIsNew = false;
                if (this.iterModel == null) {
                    this.iterModel = this.iterationModels.modelFirst;
                    iterationIsNew = true;
                }
                if (!this.processIterationModel(flowController, iterationIsNew)) {
                    return false;
                }
                ++this.iter;
                this.iterOffset = 0;
                this.iterModel = null;
                if (flowController != null && this.dataDrivenIterator != null && this.dataDrivenIterator.isPaused()) {
                    flowController.stopProcessing = true;
                    return false;
                }
            } else {
                this.resetGatheredSkipFlagsAfterNoIterations();
            }
        }
        while (this.iterModel != null || this.iterator.hasNext()) {
            boolean iterationIsNew = false;
            if (this.iterModel == null && this.iterOffset == 0) {
                ++this.iterStatusVariable.index;
                this.iterStatusVariable.current = this.iterator.next();
                iterationIsNew = true;
            }
            if (this.iterModel == null) {
                Model model = this.iterModel = this.iterator.hasNext() ? this.iterationModels.modelMiddle : this.iterationModels.modelLast;
            }
            if (!this.processIterationModel(flowController, iterationIsNew)) {
                return false;
            }
            ++this.iter;
            this.iterOffset = 0;
            this.iterModel = null;
            if (flowController == null || this.dataDrivenIterator == null || !this.dataDrivenIterator.isPaused()) continue;
            flowController.stopProcessing = true;
            return false;
        }
        this.context.decreaseLevel();
        return true;
    }

    private boolean processIterationModel(TemplateFlowController flowController, boolean iterationIsNew) {
        if (iterationIsNew) {
            this.context.increaseLevel();
            this.context.setVariable(this.iterVariableName, this.iterStatusVariable.current);
            this.context.setVariable(this.iterStatusVariableName, this.iterStatusVariable);
            this.prepareProcessing();
            if (this.dataDrivenIterator != null) {
                this.dataDrivenIterator.startIteration();
            }
        }
        this.iterOffset += this.iterModel.process(this.getProcessorTemplateHandler(), this.iterOffset, flowController);
        if (flowController != null && (this.iterOffset < this.iterModel.queueSize || flowController.stopProcessing)) {
            return false;
        }
        this.context.decreaseLevel();
        if (this.dataDrivenIterator != null) {
            this.dataDrivenIterator.finishIteration();
        }
        return true;
    }

    private static Integer computeIteratedObjectSize(Object iteratedObject) {
        if (iteratedObject == null) {
            return 0;
        }
        if (iteratedObject instanceof Collection) {
            return ((Collection)iteratedObject).size();
        }
        if (iteratedObject instanceof Map) {
            return ((Map)iteratedObject).size();
        }
        if (iteratedObject.getClass().isArray()) {
            return Array.getLength(iteratedObject);
        }
        if (iteratedObject instanceof Iterable) {
            return null;
        }
        if (iteratedObject instanceof Iterator) {
            return null;
        }
        return 1;
    }

    private static Iterator<?> computeIteratedObjectIterator(final Object iteratedObject) {
        if (iteratedObject == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (iteratedObject instanceof Collection) {
            return ((Collection)iteratedObject).iterator();
        }
        if (iteratedObject instanceof Map) {
            return ((Map)iteratedObject).entrySet().iterator();
        }
        if (iteratedObject.getClass().isArray()) {
            return new Iterator<Object>(){
                protected final Object array;
                protected final int length;
                private int i;
                {
                    this.array = iteratedObject;
                    this.length = Array.getLength(this.array);
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.i < this.length;
                }

                @Override
                public Object next() {
                    return Array.get(this.array, this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove from an array iterator");
                }
            };
        }
        if (iteratedObject instanceof Iterable) {
            return ((Iterable)iteratedObject).iterator();
        }
        if (iteratedObject instanceof Iterator) {
            return (Iterator)iteratedObject;
        }
        if (iteratedObject instanceof Enumeration) {
            return new Iterator<Object>(){
                protected final Enumeration<?> enumeration;
                {
                    this.enumeration = (Enumeration)iteratedObject;
                }

                @Override
                public boolean hasNext() {
                    return this.enumeration.hasMoreElements();
                }

                @Override
                public Object next() {
                    return this.enumeration.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove from an Enumeration iterator");
                }
            };
        }
        return Collections.singletonList(iteratedObject).iterator();
    }

    private IterationModels computeIterationModels(IterationWhiteSpaceHandling iterationWhiteSpaceHandling) {
        if (iterationWhiteSpaceHandling == IterationWhiteSpaceHandling.ZERO_ITER) {
            return IterationModels.EMPTY;
        }
        Model innerModel = this.getInnerModel();
        int gatheredModelSize = innerModel.size();
        if (iterationWhiteSpaceHandling == IterationWhiteSpaceHandling.SINGLE_ITER) {
            return new IterationModels(innerModel, innerModel, innerModel);
        }
        if (!this.templateMode.isText()) {
            if (this.precedingWhitespace != null) {
                Model modelWithWhiteSpace = new Model(innerModel);
                modelWithWhiteSpace.insert(0, this.precedingWhitespace);
                return new IterationModels(innerModel, modelWithWhiteSpace, modelWithWhiteSpace);
            }
            return new IterationModels(innerModel, innerModel, innerModel);
        }
        if (innerModel.size() <= 2) {
            return new IterationModels(innerModel, innerModel, innerModel);
        }
        int firstBodyEventCutPoint = -1;
        int lastBodyEventCutPoint = -1;
        ITemplateEvent firstBodyEvent = innerModel.get(1);
        Text firstTextBodyEvent = null;
        if (innerModel.get(0) instanceof OpenElementTag && firstBodyEvent instanceof IText) {
            firstTextBodyEvent = Text.asEngineText((IText)firstBodyEvent);
            int firstTextEventLen = firstTextBodyEvent.length();
            for (int i2 = 0; i2 < firstTextEventLen && firstBodyEventCutPoint < 0; ++i2) {
                char c = firstTextBodyEvent.charAt(i2);
                if (c == '\n') {
                    firstBodyEventCutPoint = i2 + 1;
                    break;
                }
                if (!Character.isWhitespace(c)) break;
            }
        }
        ITemplateEvent lastBodyEvent = innerModel.get(gatheredModelSize - 2);
        Text lastTextBodyEvent = null;
        if (firstBodyEventCutPoint >= 0 && innerModel.get(gatheredModelSize - 1) instanceof CloseElementTag && lastBodyEvent instanceof IText) {
            lastTextBodyEvent = Text.asEngineText((IText)lastBodyEvent);
            int lastTextEventLen = lastTextBodyEvent.length();
            for (int i3 = lastTextEventLen - 1; i3 >= 0 && lastBodyEventCutPoint < 0; --i3) {
                char c = lastTextBodyEvent.charAt(i3);
                if (c == '\n') {
                    lastBodyEventCutPoint = i3 + 1;
                    break;
                }
                if (!Character.isWhitespace(c)) break;
            }
        }
        if (firstBodyEventCutPoint < 0 || lastBodyEventCutPoint < 0) {
            return new IterationModels(innerModel, innerModel, innerModel);
        }
        if (firstBodyEvent == lastBodyEvent) {
            Text textForFirst = new Text(firstTextBodyEvent.subSequence(0, lastBodyEventCutPoint));
            Text textForMiddle = new Text(firstTextBodyEvent.subSequence(firstBodyEventCutPoint, lastBodyEventCutPoint));
            Text textForLast = new Text(firstTextBodyEvent.subSequence(firstBodyEventCutPoint, firstTextBodyEvent.length()));
            Model modelFirst = new Model(innerModel);
            modelFirst.replace(1, textForFirst);
            Model modelMiddle = new Model(innerModel);
            modelMiddle.replace(1, textForMiddle);
            Model modelLast = new Model(innerModel);
            modelLast.replace(1, textForLast);
            return new IterationModels(modelFirst, modelMiddle, modelLast);
        }
        Model modelFirst = new Model(innerModel);
        Model modelMiddle = new Model(innerModel);
        Model modelLast = new Model(innerModel);
        if (firstBodyEventCutPoint > 0) {
            Text headTextForMiddleAndMax = new Text(firstTextBodyEvent.subSequence(firstBodyEventCutPoint, firstTextBodyEvent.length()));
            modelMiddle.replace(1, headTextForMiddleAndMax);
            modelLast.replace(1, headTextForMiddleAndMax);
        }
        if (lastBodyEventCutPoint < lastTextBodyEvent.length()) {
            Text tailTextForFirstAndMiddle = new Text(lastTextBodyEvent.subSequence(0, lastBodyEventCutPoint));
            modelFirst.replace(gatheredModelSize - 2, tailTextForFirstAndMiddle);
            modelMiddle.replace(gatheredModelSize - 2, tailTextForFirstAndMiddle);
        }
        return new IterationModels(modelFirst, modelMiddle, modelLast);
    }

    private static final class IterationModels {
        static IterationModels EMPTY = new IterationModels(null, null, null);
        final Model modelFirst;
        final Model modelMiddle;
        final Model modelLast;
        final boolean empty;

        IterationModels(Model modelFirst, Model modelMiddle, Model modelLast) {
            this.modelFirst = modelFirst;
            this.modelMiddle = modelMiddle;
            this.modelLast = modelLast;
            this.empty = this.modelFirst == null && this.modelMiddle == null && this.modelLast == null;
        }

        boolean isEmpty() {
            return this.empty;
        }
    }

    static enum IterationWhiteSpaceHandling {
        ZERO_ITER,
        SINGLE_ITER,
        MULTIPLE_ITER;

    }
}

