/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.thymeleaf.engine.ElementName;
import org.thymeleaf.engine.HTMLElementName;
import org.thymeleaf.engine.TextElementName;
import org.thymeleaf.engine.XMLElementName;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.TextUtils;

public class ElementNames {
    private static final ElementNamesRepository htmlElementNamesRepository = new ElementNamesRepository(TemplateMode.HTML);
    private static final ElementNamesRepository xmlElementNamesRepository = new ElementNamesRepository(TemplateMode.XML);
    private static final ElementNamesRepository textElementNamesRepository = new ElementNamesRepository(TemplateMode.TEXT);

    private static TextElementName buildTextElementName(char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (elementNameBuffer == null) {
            throw new IllegalArgumentException("Element name buffer cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Element name offset and len must be equal or greater than zero");
        }
        int i2 = elementNameOffset;
        int n = elementNameLen;
        while (n-- != 0) {
            char c;
            if ((c = elementNameBuffer[i2++]) != ':' || c != ':') continue;
            if (i2 == elementNameOffset + 1) {
                return TextElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
            }
            return TextElementName.forName(new String(elementNameBuffer, elementNameOffset, i2 - (elementNameOffset + 1)), new String(elementNameBuffer, i2, elementNameOffset + elementNameLen - i2));
        }
        return TextElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
    }

    private static XMLElementName buildXMLElementName(char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (elementNameBuffer == null || elementNameLen == 0) {
            throw new IllegalArgumentException("Element name buffer cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Element name offset and len must be equal or greater than zero");
        }
        int i2 = elementNameOffset;
        int n = elementNameLen;
        while (n-- != 0) {
            char c;
            if ((c = elementNameBuffer[i2++]) != ':' || c != ':') continue;
            if (i2 == elementNameOffset + 1) {
                return XMLElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
            }
            return XMLElementName.forName(new String(elementNameBuffer, elementNameOffset, i2 - (elementNameOffset + 1)), new String(elementNameBuffer, i2, elementNameOffset + elementNameLen - i2));
        }
        return XMLElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
    }

    private static HTMLElementName buildHTMLElementName(char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (elementNameBuffer == null || elementNameLen == 0) {
            throw new IllegalArgumentException("Element name buffer cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Element name offset and len must be equal or greater than zero");
        }
        int i2 = elementNameOffset;
        int n = elementNameLen;
        while (n-- != 0) {
            char c;
            if ((c = elementNameBuffer[i2++]) != ':' && c != '-') continue;
            if (c == ':') {
                if (i2 == elementNameOffset + 1) {
                    return HTMLElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
                }
                if (TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xml:", 0, 4, elementNameBuffer, elementNameOffset, i2 - elementNameOffset) || TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xmlns:", 0, 6, elementNameBuffer, elementNameOffset, i2 - elementNameOffset)) {
                    return HTMLElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
                }
                return HTMLElementName.forName(new String(elementNameBuffer, elementNameOffset, i2 - (elementNameOffset + 1)), new String(elementNameBuffer, i2, elementNameOffset + elementNameLen - i2));
            }
            if (c != '-') continue;
            if (i2 == elementNameOffset + 1) {
                return HTMLElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
            }
            return HTMLElementName.forName(new String(elementNameBuffer, elementNameOffset, i2 - (elementNameOffset + 1)), new String(elementNameBuffer, i2, elementNameOffset + elementNameLen - i2));
        }
        return HTMLElementName.forName(null, new String(elementNameBuffer, elementNameOffset, elementNameLen));
    }

    private static TextElementName buildTextElementName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Element name cannot be null");
        }
        int i2 = 0;
        int n = elementName.length();
        while (n-- != 0) {
            char c;
            if ((c = elementName.charAt(i2++)) != ':' || c != ':') continue;
            if (i2 == 1) {
                return TextElementName.forName(null, elementName);
            }
            return TextElementName.forName(elementName.substring(0, i2 - 1), elementName.substring(i2, elementName.length()));
        }
        return TextElementName.forName(null, elementName);
    }

    private static XMLElementName buildXMLElementName(String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Element name cannot be null or empty");
        }
        int i2 = 0;
        int n = elementName.length();
        while (n-- != 0) {
            char c;
            if ((c = elementName.charAt(i2++)) != ':' || c != ':') continue;
            if (i2 == 1) {
                return XMLElementName.forName(null, elementName);
            }
            return XMLElementName.forName(elementName.substring(0, i2 - 1), elementName.substring(i2, elementName.length()));
        }
        return XMLElementName.forName(null, elementName);
    }

    private static HTMLElementName buildHTMLElementName(String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Element name cannot be null or empty");
        }
        int i2 = 0;
        int n = elementName.length();
        while (n-- != 0) {
            char c;
            if ((c = elementName.charAt(i2++)) != ':' && c != '-') continue;
            if (c == ':') {
                if (i2 == 1) {
                    return HTMLElementName.forName(null, elementName);
                }
                if (TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xml:", 0, 4, elementName, 0, i2) || TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xmlns:", 0, 6, elementName, 0, i2)) {
                    return HTMLElementName.forName(null, elementName);
                }
                return HTMLElementName.forName(elementName.substring(0, i2 - 1), elementName.substring(i2, elementName.length()));
            }
            if (c != '-') continue;
            if (i2 == 1) {
                return HTMLElementName.forName(null, elementName);
            }
            return HTMLElementName.forName(elementName.substring(0, i2 - 1), elementName.substring(i2, elementName.length()));
        }
        return HTMLElementName.forName(null, elementName);
    }

    private static TextElementName buildTextElementName(String prefix, String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Element name cannot be null or empty");
        }
        if (prefix == null || prefix.trim().length() == 0) {
            return ElementNames.buildTextElementName(elementName);
        }
        return TextElementName.forName(prefix, elementName);
    }

    private static XMLElementName buildXMLElementName(String prefix, String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Element name cannot be null or empty");
        }
        if (prefix == null || prefix.trim().length() == 0) {
            return ElementNames.buildXMLElementName(elementName);
        }
        return XMLElementName.forName(prefix, elementName);
    }

    private static HTMLElementName buildHTMLElementName(String prefix, String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Element name cannot be null or empty");
        }
        if (prefix == null || prefix.trim().length() == 0) {
            return ElementNames.buildHTMLElementName(elementName);
        }
        return HTMLElementName.forName(prefix, elementName);
    }

    public static ElementName forName(TemplateMode templateMode, char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        if (templateMode == TemplateMode.HTML) {
            return ElementNames.forHTMLName(elementNameBuffer, elementNameOffset, elementNameLen);
        }
        if (templateMode == TemplateMode.XML) {
            return ElementNames.forXMLName(elementNameBuffer, elementNameOffset, elementNameLen);
        }
        if (templateMode.isText()) {
            return ElementNames.forTextName(elementNameBuffer, elementNameOffset, elementNameLen);
        }
        throw new IllegalArgumentException("Unknown template mode '" + (Object)((Object)templateMode) + "'");
    }

    public static ElementName forName(TemplateMode templateMode, String elementName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        if (templateMode == TemplateMode.HTML) {
            return ElementNames.forHTMLName(elementName);
        }
        if (templateMode == TemplateMode.XML) {
            return ElementNames.forXMLName(elementName);
        }
        if (templateMode.isText()) {
            return ElementNames.forTextName(elementName);
        }
        throw new IllegalArgumentException("Unknown template mode '" + (Object)((Object)templateMode) + "'");
    }

    public static ElementName forName(TemplateMode templateMode, String prefix, String elementName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        if (templateMode == TemplateMode.HTML) {
            return ElementNames.forHTMLName(prefix, elementName);
        }
        if (templateMode == TemplateMode.XML) {
            return ElementNames.forXMLName(prefix, elementName);
        }
        if (templateMode.isText()) {
            return ElementNames.forTextName(prefix, elementName);
        }
        throw new IllegalArgumentException("Unknown template mode '" + (Object)((Object)templateMode) + "'");
    }

    public static TextElementName forTextName(char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (elementNameBuffer == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextElementName)textElementNamesRepository.getElement(elementNameBuffer, elementNameOffset, elementNameLen);
    }

    public static XMLElementName forXMLName(char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (elementNameBuffer == null || elementNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (XMLElementName)xmlElementNamesRepository.getElement(elementNameBuffer, elementNameOffset, elementNameLen);
    }

    public static HTMLElementName forHTMLName(char[] elementNameBuffer, int elementNameOffset, int elementNameLen) {
        if (elementNameBuffer == null || elementNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (HTMLElementName)htmlElementNamesRepository.getElement(elementNameBuffer, elementNameOffset, elementNameLen);
    }

    public static TextElementName forTextName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextElementName)textElementNamesRepository.getElement(elementName);
    }

    public static XMLElementName forXMLName(String elementName) {
        if (elementName == null || elementName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLElementName)xmlElementNamesRepository.getElement(elementName);
    }

    public static HTMLElementName forHTMLName(String elementName) {
        if (elementName == null || elementName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLElementName)htmlElementNamesRepository.getElement(elementName);
    }

    public static TextElementName forTextName(String prefix, String elementName) {
        if (elementName == null || elementName.trim().length() == 0 && prefix != null && prefix.trim().length() > 0) {
            throw new IllegalArgumentException("Name cannot be null (nor empty if prefix is not empty)");
        }
        return (TextElementName)textElementNamesRepository.getElement(prefix, elementName);
    }

    public static XMLElementName forXMLName(String prefix, String elementName) {
        if (elementName == null || elementName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLElementName)xmlElementNamesRepository.getElement(prefix, elementName);
    }

    public static HTMLElementName forHTMLName(String prefix, String elementName) {
        if (elementName == null || elementName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLElementName)htmlElementNamesRepository.getElement(prefix, elementName);
    }

    private ElementNames() {
    }

    static final class ElementNamesRepository {
        private final TemplateMode templateMode;
        private final List<String> repositoryNames;
        private final List<ElementName> repository;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        ElementNamesRepository(TemplateMode templateMode) {
            this.templateMode = templateMode;
            this.repositoryNames = new ArrayList<String>(500);
            this.repository = new ArrayList<ElementName>(500);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementName getElement(char[] text, int offset, int len) {
            this.readLock.lock();
            try {
                int index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
                if (index >= 0) {
                    ElementName elementName = this.repository.get(index);
                    return elementName;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                ElementName elementName = this.storeElement(text, offset, len);
                return elementName;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementName getElement(String completeElementName) {
            this.readLock.lock();
            try {
                int index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                if (index >= 0) {
                    ElementName elementName = this.repository.get(index);
                    return elementName;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                ElementName elementName = this.storeElement(completeElementName);
                return elementName;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementName getElement(String prefix, String elementName) {
            this.readLock.lock();
            try {
                int index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, elementName);
                if (index >= 0) {
                    ElementName elementName2 = this.repository.get(index);
                    return elementName2;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                ElementName elementName3 = this.storeElement(prefix, elementName);
                return elementName3;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private ElementName storeElement(char[] text, int offset, int len) {
            String[] completeElementNames;
            int index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
            if (index >= 0) {
                return this.repository.get(index);
            }
            ElementName name = this.templateMode == TemplateMode.HTML ? ElementNames.buildHTMLElementName(text, offset, len) : (this.templateMode == TemplateMode.XML ? ElementNames.buildXMLElementName(text, offset, len) : ElementNames.buildTextElementName(text, offset, len));
            for (String completeElementName : completeElementNames = name.completeElementNames) {
                index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, name);
            }
            return name;
        }

        private ElementName storeElement(String elementName) {
            String[] completeElementNames;
            int index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, elementName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            ElementName name = this.templateMode == TemplateMode.HTML ? ElementNames.buildHTMLElementName(elementName) : (this.templateMode == TemplateMode.XML ? ElementNames.buildXMLElementName(elementName) : ElementNames.buildTextElementName(elementName));
            for (String completeElementName : completeElementNames = name.completeElementNames) {
                index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, name);
            }
            return name;
        }

        private ElementName storeElement(String prefix, String elementName) {
            String[] completeElementNames;
            int index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, elementName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            ElementName name = this.templateMode == TemplateMode.HTML ? ElementNames.buildHTMLElementName(prefix, elementName) : (this.templateMode == TemplateMode.XML ? ElementNames.buildXMLElementName(prefix, elementName) : ElementNames.buildTextElementName(prefix, elementName));
            for (String completeElementName : completeElementNames = name.completeElementNames) {
                index = ElementNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, name);
            }
            return name;
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, char[] text, int offset, int len) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, 0, midVal.length(), text, offset, len);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String text) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, text);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String prefix, String elementName) {
            if (prefix == null || prefix.trim().length() == 0) {
                return ElementNamesRepository.binarySearch(caseSensitive, values, elementName);
            }
            int prefixLen = prefix.length();
            int elementNameLen = elementName.length();
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int cmp;
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int midValLen = midVal.length();
                if (TextUtils.startsWith(caseSensitive, (CharSequence)midVal, prefix)) {
                    if (midValLen <= prefixLen) {
                        low = mid + 1;
                        continue;
                    }
                    cmp = midVal.charAt(prefixLen) - 58;
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefixLen + 1, midValLen - (prefixLen + 1), elementName, 0, elementNameLen);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefix);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                throw new IllegalStateException("Bad comparison of midVal \"" + midVal + "\" and prefix \"" + prefix + "\"");
            }
            return -(low + 1);
        }
    }
}

