/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.AbstractEngineContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.ILazyContextVariable;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.inline.NoOpInliner;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.util.Validate;

public class EngineContext
extends AbstractEngineContext
implements IEngineContext {
    private static final int DEFAULT_ELEMENT_HIERARCHY_SIZE = 20;
    private static final int DEFAULT_LEVELS_SIZE = 10;
    private static final int DEFAULT_MAP_SIZE = 5;
    private int level = 0;
    private int index = 0;
    private int[] levels = new int[10];
    private HashMap<String, Object>[] maps = new HashMap[10];
    private SelectionTarget[] selectionTargets = new SelectionTarget[10];
    private IInliner[] inliners = new IInliner[10];
    private TemplateData[] templateDatas = new TemplateData[10];
    private IProcessableElementTag[] elementTags = new IProcessableElementTag[20];
    private SelectionTarget lastSelectionTarget = null;
    private IInliner lastInliner = null;
    private TemplateData lastTemplateData = null;
    private final List<TemplateData> templateStack;
    private static final Object NON_EXISTING = new Object(){

        public String toString() {
            return "(*removed*)";
        }
    };
    private static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };

    public EngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, Locale locale, Map<String, Object> variables) {
        super(configuration, templateResolutionAttributes, locale);
        Arrays.fill(this.levels, Integer.MAX_VALUE);
        Arrays.fill(this.maps, null);
        Arrays.fill(this.selectionTargets, null);
        Arrays.fill(this.inliners, null);
        Arrays.fill(this.templateDatas, null);
        Arrays.fill(this.elementTags, null);
        this.levels[0] = 0;
        this.templateDatas[0] = templateData;
        this.lastTemplateData = templateData;
        this.templateStack = new ArrayList<TemplateData>(10);
        this.templateStack.add(templateData);
        if (variables != null) {
            this.setVariables(variables);
        }
    }

    @Override
    public boolean containsVariable(String name) {
        int n = this.index + 1;
        while (n-- != 0) {
            Object value;
            HashMap<String, Object> map = this.maps[n];
            if (map == null || map.size() <= 0 || (value = map.get(name)) == null) continue;
            return value != NON_EXISTING;
        }
        return false;
    }

    @Override
    public Object getVariable(String key) {
        int n = this.index + 1;
        while (n-- != 0) {
            Object value;
            HashMap<String, Object> map = this.maps[n];
            if (map == null || map.size() <= 0 || (value = map.get(key)) == null) continue;
            if (value == NON_EXISTING || value == NULL) {
                return null;
            }
            return EngineContext.resolveLazy(value);
        }
        return null;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> variableNames = new HashSet<String>();
        int n = this.index + 1;
        int i2 = 0;
        while (n-- != 0) {
            if (this.maps[i2] != null) {
                for (Map.Entry<String, Object> mapEntry : this.maps[i2].entrySet()) {
                    if (mapEntry.getValue() == NON_EXISTING) {
                        variableNames.remove(mapEntry.getKey());
                        continue;
                    }
                    variableNames.add(mapEntry.getKey());
                }
            }
            ++i2;
        }
        return variableNames;
    }

    @Override
    public void setVariable(String name, Object value) {
        this.ensureLevelInitialized(5);
        if (value == NON_EXISTING && this.level == 0) {
            this.maps[this.index].remove(name);
        } else if (value == null) {
            this.maps[this.index].put(name, NULL);
        } else {
            this.maps[this.index].put(name, value);
        }
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.ensureLevelInitialized(Math.max(5, variables.size() + 2));
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                this.maps[this.index].put(entry.getKey(), NULL);
                continue;
            }
            this.maps[this.index].put(entry.getKey(), value);
        }
    }

    @Override
    public void removeVariable(String name) {
        if (this.containsVariable(name)) {
            this.setVariable(name, NON_EXISTING);
        }
    }

    @Override
    public boolean isVariableLocal(String name) {
        int n = this.index + 1;
        while (n-- > 1) {
            if (this.maps[n] == null || !this.maps[n].containsKey(name)) continue;
            Object result = this.maps[n].get(name);
            return result != NON_EXISTING;
        }
        return false;
    }

    @Override
    public boolean hasSelectionTarget() {
        if (this.lastSelectionTarget != null) {
            return true;
        }
        int n = this.index + 1;
        while (n-- != 0) {
            if (this.selectionTargets[n] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getSelectionTarget() {
        if (this.lastSelectionTarget != null) {
            return this.lastSelectionTarget.selectionTarget;
        }
        int n = this.index + 1;
        while (n-- != 0) {
            if (this.selectionTargets[n] == null) continue;
            this.lastSelectionTarget = this.selectionTargets[n];
            return this.lastSelectionTarget.selectionTarget;
        }
        return null;
    }

    @Override
    public void setSelectionTarget(Object selectionTarget) {
        this.ensureLevelInitialized(-1);
        this.selectionTargets[this.index] = this.lastSelectionTarget = new SelectionTarget(selectionTarget);
    }

    @Override
    public IInliner getInliner() {
        if (this.lastInliner != null) {
            if (this.lastInliner == NoOpInliner.INSTANCE) {
                return null;
            }
            return this.lastInliner;
        }
        int n = this.index + 1;
        while (n-- != 0) {
            if (this.inliners[n] == null) continue;
            this.lastInliner = this.inliners[n];
            if (this.lastInliner == NoOpInliner.INSTANCE) {
                return null;
            }
            return this.lastInliner;
        }
        return null;
    }

    @Override
    public void setInliner(IInliner inliner) {
        this.ensureLevelInitialized(-1);
        this.inliners[this.index] = this.lastInliner = inliner == null ? NoOpInliner.INSTANCE : inliner;
    }

    @Override
    public TemplateData getTemplateData() {
        if (this.lastTemplateData != null) {
            return this.lastTemplateData;
        }
        int n = this.index + 1;
        while (n-- != 0) {
            if (this.templateDatas[n] == null) continue;
            this.lastTemplateData = this.templateDatas[n];
            return this.lastTemplateData;
        }
        return null;
    }

    @Override
    public void setTemplateData(TemplateData templateData) {
        Validate.notNull(templateData, "Template Data cannot be null");
        this.ensureLevelInitialized(-1);
        this.templateDatas[this.index] = this.lastTemplateData = templateData;
        this.templateStack.clear();
    }

    @Override
    public List<TemplateData> getTemplateStack() {
        if (!this.templateStack.isEmpty()) {
            return Collections.unmodifiableList(new ArrayList<TemplateData>(this.templateStack));
        }
        for (int i2 = 0; i2 <= this.index; ++i2) {
            if (this.templateDatas[i2] == null) continue;
            this.templateStack.add(this.templateDatas[i2]);
        }
        return Collections.unmodifiableList(new ArrayList<TemplateData>(this.templateStack));
    }

    @Override
    public void setElementTag(IProcessableElementTag elementTag) {
        if (this.elementTags.length <= this.level) {
            this.elementTags = Arrays.copyOf(this.elementTags, Math.max(this.level, this.elementTags.length + 20));
        }
        this.elementTags[this.level] = elementTag;
    }

    @Override
    public List<IProcessableElementTag> getElementStack() {
        ArrayList<IProcessableElementTag> elementStack = new ArrayList<IProcessableElementTag>(this.level);
        for (int i2 = 0; i2 <= this.level && i2 < this.elementTags.length; ++i2) {
            if (this.elementTags[i2] == null) continue;
            elementStack.add(this.elementTags[i2]);
        }
        return Collections.unmodifiableList(elementStack);
    }

    @Override
    public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
        ArrayList<IProcessableElementTag> elementStack = new ArrayList<IProcessableElementTag>(this.level);
        for (int i2 = contextLevel + 1; i2 <= this.level && i2 < this.elementTags.length; ++i2) {
            if (this.elementTags[i2] == null) continue;
            elementStack.add(this.elementTags[i2]);
        }
        return Collections.unmodifiableList(elementStack);
    }

    private void ensureLevelInitialized(int requiredSize) {
        if (this.levels[this.index] != this.level) {
            ++this.index;
            if (this.levels.length == this.index) {
                this.levels = Arrays.copyOf(this.levels, this.levels.length + 10);
                Arrays.fill(this.levels, this.index, this.levels.length, Integer.MAX_VALUE);
                this.maps = Arrays.copyOf(this.maps, this.maps.length + 10);
                this.selectionTargets = Arrays.copyOf(this.selectionTargets, this.selectionTargets.length + 10);
                this.inliners = Arrays.copyOf(this.inliners, this.inliners.length + 10);
                this.templateDatas = Arrays.copyOf(this.templateDatas, this.templateDatas.length + 10);
            }
            this.levels[this.index] = this.level;
        }
        if (requiredSize >= 0 && this.maps[this.index] == null) {
            this.maps[this.index] = new HashMap(requiredSize, 1.0f);
        }
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public void increaseLevel() {
        ++this.level;
    }

    @Override
    public void decreaseLevel() {
        Validate.isTrue(this.level > 0, "Cannot decrease variable map level below 0");
        if (this.levels[this.index] == this.level) {
            this.levels[this.index] = Integer.MAX_VALUE;
            if (this.maps[this.index] != null) {
                this.maps[this.index].clear();
            }
            this.selectionTargets[this.index] = null;
            this.inliners[this.index] = null;
            this.templateDatas[this.index] = null;
            --this.index;
            this.lastSelectionTarget = null;
            this.lastInliner = null;
            this.lastTemplateData = null;
            this.templateStack.clear();
        }
        if (this.level < this.elementTags.length) {
            this.elementTags[this.level] = null;
        }
        --this.level;
    }

    public String getStringRepresentationByLevel() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append('{');
        int n = this.index + 1;
        while (n-- != 0) {
            LinkedHashMap<String, Object> levelVars = new LinkedHashMap<String, Object>();
            if (this.maps[n] != null) {
                ArrayList<String> entryNames = new ArrayList<String>(this.maps[n].keySet());
                Collections.sort(entryNames);
                block1: for (String name : entryNames) {
                    Object value = this.maps[n].get(name);
                    if (value == NON_EXISTING) {
                        int n2 = n;
                        while (n2-- != 0) {
                            if (this.maps[n2] == null || !this.maps[n2].containsKey(name)) continue;
                            if (this.maps[n2].get(name) == NON_EXISTING) continue block1;
                            levelVars.put(name, value);
                            continue block1;
                        }
                        continue;
                    }
                    levelVars.put(name, value);
                }
            }
            if (n != 0 && levelVars.isEmpty() && this.selectionTargets[n] == null && this.inliners[n] == null && this.templateDatas[n] == null) continue;
            if (strBuilder.length() > 1) {
                strBuilder.append(',');
            }
            strBuilder.append(this.levels[n]).append(":");
            if (!levelVars.isEmpty() || n == 0) {
                strBuilder.append(levelVars);
            }
            if (this.selectionTargets[n] != null) {
                strBuilder.append("<").append(this.selectionTargets[n].selectionTarget).append(">");
            }
            if (this.inliners[n] != null) {
                strBuilder.append("[").append(this.inliners[n].getName()).append("]");
            }
            if (this.templateDatas[n] == null) continue;
            strBuilder.append("(").append(this.templateDatas[n].getTemplate()).append(")");
        }
        strBuilder.append("}[");
        strBuilder.append(this.level);
        strBuilder.append(']');
        return strBuilder.toString();
    }

    public String toString() {
        LinkedHashMap<String, Object> equivalentMap = new LinkedHashMap<String, Object>();
        int n = this.index + 1;
        int i2 = 0;
        while (n-- != 0) {
            if (this.maps[i2] != null) {
                ArrayList<String> entryNames = new ArrayList<String>(this.maps[i2].keySet());
                Collections.sort(entryNames);
                for (String name : entryNames) {
                    Object value = this.maps[i2].get(name);
                    if (value == NON_EXISTING) {
                        equivalentMap.remove(name);
                        continue;
                    }
                    equivalentMap.put(name, value);
                }
            }
            ++i2;
        }
        String textInliningStr = this.getInliner() != null ? "[" + this.getInliner().getName() + "]" : "";
        String templateDataStr = "(" + this.getTemplateData().getTemplate() + ")";
        return ((Object)equivalentMap).toString() + (this.hasSelectionTarget() ? "<" + this.getSelectionTarget() + ">" : "") + textInliningStr + templateDataStr;
    }

    private static Object resolveLazy(Object variable) {
        if (variable != null && variable instanceof ILazyContextVariable) {
            return ((ILazyContextVariable)variable).getValue();
        }
        return variable;
    }

    private static final class SelectionTarget {
        final Object selectionTarget;

        SelectionTarget(Object selectionTarget) {
            this.selectionTarget = selectionTarget;
        }
    }
}

