/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.tunnel.payload;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.devtools.tunnel.payload.HttpTunnelPayload;
import org.springframework.util.Assert;

public class HttpTunnelPayloadForwarder {
    private static final int MAXIMUM_QUEUE_SIZE = 100;
    private final Map<Long, HttpTunnelPayload> queue = new HashMap<Long, HttpTunnelPayload>();
    private final Object monitor = new Object();
    private final WritableByteChannel targetChannel;
    private long lastRequestSeq = 0L;

    public HttpTunnelPayloadForwarder(WritableByteChannel targetChannel) {
        Assert.notNull((Object)targetChannel, "TargetChannel must not be null");
        this.targetChannel = targetChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(HttpTunnelPayload payload) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            long seq = payload.getSequence();
            if (this.lastRequestSeq != seq - 1L) {
                Assert.state(this.queue.size() < 100, "Too many messages queued");
                this.queue.put(seq, payload);
                return;
            }
            payload.logOutgoing();
            payload.writeTo(this.targetChannel);
            this.lastRequestSeq = seq;
            HttpTunnelPayload queuedItem = this.queue.get(seq + 1L);
            if (queuedItem != null) {
                this.forward(queuedItem);
            }
        }
    }
}

