/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.ClassUtils;

public abstract class AgentReloader {
    private static final Set<String> AGENT_CLASSES;

    private AgentReloader() {
    }

    public static boolean isActive() {
        return AgentReloader.isActive(null) || AgentReloader.isActive(AgentReloader.class.getClassLoader()) || AgentReloader.isActive(ClassLoader.getSystemClassLoader());
    }

    private static boolean isActive(ClassLoader classLoader) {
        for (String agentClass : AGENT_CLASSES) {
            if (!ClassUtils.isPresent(agentClass, classLoader)) continue;
            return true;
        }
        return false;
    }

    static {
        LinkedHashSet<String> agentClasses = new LinkedHashSet<String>();
        agentClasses.add("org.zeroturnaround.javarebel.Integration");
        agentClasses.add("org.zeroturnaround.javarebel.ReloaderFactory");
        agentClasses.add("org.hotswap.agent.HotswapAgent");
        AGENT_CLASSES = Collections.unmodifiableSet(agentClasses);
    }
}

