/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;

class ConfigDataLocationBindHandler
extends AbstractBindHandler {
    ConfigDataLocationBindHandler() {
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
        if (result instanceof ConfigDataLocation) {
            return this.withOrigin(context, (ConfigDataLocation)result);
        }
        if (result instanceof List) {
            List list = ((List)result).stream().filter(Objects::nonNull).collect(Collectors.toList());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object element = list.get(i2);
                if (!(element instanceof ConfigDataLocation)) continue;
                list.set(i2, this.withOrigin(context, (ConfigDataLocation)element));
            }
            return list;
        }
        if (result instanceof ConfigDataLocation[]) {
            ConfigDataLocation[] locations = (ConfigDataLocation[])Arrays.stream((ConfigDataLocation[])result).filter(Objects::nonNull).toArray(ConfigDataLocation[]::new);
            for (int i3 = 0; i3 < locations.length; ++i3) {
                locations[i3] = this.withOrigin(context, locations[i3]);
            }
            return locations;
        }
        return result;
    }

    private ConfigDataLocation withOrigin(BindContext context, ConfigDataLocation result) {
        if (result.getOrigin() != null) {
            return result;
        }
        Origin origin = Origin.from(context.getConfigurationProperty());
        return result.withOrigin(origin);
    }
}

