/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.select;

import java.util.Arrays;
import org.attoparser.select.IMarkupSelectorItem;
import org.attoparser.select.MarkupSelectorFilter;
import org.attoparser.select.SelectorElementBuffer;
import org.attoparser.util.TextUtil;

final class MarkupSelectorItem
implements IMarkupSelectorItem {
    static final String CONTENT_SELECTOR = "content()";
    static final String TEXT_SELECTOR = "text()";
    static final String COMMENT_SELECTOR = "comment()";
    static final String CDATA_SECTION_SELECTOR = "cdata()";
    static final String DOC_TYPE_CLAUSE_SELECTOR = "doctype()";
    static final String XML_DECLARATION_SELECTOR = "xmldecl()";
    static final String PROCESSING_INSTRUCTION_SELECTOR = "procinstr()";
    static final String ID_MODIFIER_SEPARATOR = "#";
    static final String CLASS_MODIFIER_SEPARATOR = ".";
    static final String REFERENCE_MODIFIER_SEPARATOR = "%";
    static final String ID_ATTRIBUTE_NAME = "id";
    static final String CLASS_ATTRIBUTE_NAME = "class";
    static final String ODD_SELECTOR = "odd()";
    static final String EVEN_SELECTOR = "even()";
    private final boolean html;
    private final boolean anyLevel;
    private final boolean contentSelector;
    private final boolean textSelector;
    private final boolean commentSelector;
    private final boolean cdataSectionSelector;
    private final boolean docTypeClauseSelector;
    private final boolean xmlDeclarationSelector;
    private final boolean processingInstructionSelector;
    private final String selectorPath;
    private final int selectorPathLen;
    private final IndexCondition index;
    private final IAttributeCondition attributeCondition;
    private final boolean requiresAttributesInElement;

    MarkupSelectorItem(boolean html, boolean anyLevel, boolean contentSelector, boolean textSelector, boolean commentSelector, boolean cdataSectionSelector, boolean docTypeClauseSelector, boolean xmlDeclarationSelector, boolean processingInstructionSelector, String selectorPath, IndexCondition index, IAttributeCondition attributeCondition) {
        this.html = html;
        this.anyLevel = anyLevel;
        this.contentSelector = contentSelector;
        this.textSelector = textSelector;
        this.commentSelector = commentSelector;
        this.cdataSectionSelector = cdataSectionSelector;
        this.docTypeClauseSelector = docTypeClauseSelector;
        this.xmlDeclarationSelector = xmlDeclarationSelector;
        this.processingInstructionSelector = processingInstructionSelector;
        this.selectorPath = selectorPath;
        this.selectorPathLen = selectorPath != null ? selectorPath.length() : 0;
        this.index = index;
        this.attributeCondition = attributeCondition;
        this.requiresAttributesInElement = MarkupSelectorItem.computeRequiresAttributesInElement(this.attributeCondition);
    }

    private static boolean computeRequiresAttributesInElement(IAttributeCondition attributeCondition) {
        if (attributeCondition == null) {
            return false;
        }
        if (attributeCondition instanceof AttributeConditionRelation) {
            AttributeConditionRelation relation = (AttributeConditionRelation)attributeCondition;
            return MarkupSelectorItem.computeRequiresAttributesInElement(relation.left) || MarkupSelectorItem.computeRequiresAttributesInElement(relation.right);
        }
        AttributeCondition attrCondition = (AttributeCondition)attributeCondition;
        return !attrCondition.operator.equals((Object)AttributeCondition.Operator.NOT_EQUALS) && !attrCondition.operator.equals((Object)AttributeCondition.Operator.NOT_EXISTS);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        if (this.anyLevel) {
            strBuilder.append("//");
        } else {
            strBuilder.append("/");
        }
        if (this.selectorPath != null) {
            strBuilder.append(this.selectorPath);
        } else if (this.contentSelector) {
            strBuilder.append(CONTENT_SELECTOR);
        } else if (this.textSelector) {
            strBuilder.append(TEXT_SELECTOR);
        } else if (this.commentSelector) {
            strBuilder.append(COMMENT_SELECTOR);
        } else if (this.cdataSectionSelector) {
            strBuilder.append(CDATA_SECTION_SELECTOR);
        } else if (this.docTypeClauseSelector) {
            strBuilder.append(DOC_TYPE_CLAUSE_SELECTOR);
        } else if (this.xmlDeclarationSelector) {
            strBuilder.append(XML_DECLARATION_SELECTOR);
        } else if (this.processingInstructionSelector) {
            strBuilder.append(PROCESSING_INSTRUCTION_SELECTOR);
        } else {
            strBuilder.append("*");
        }
        if (this.attributeCondition != null) {
            strBuilder.append("[");
            strBuilder.append(MarkupSelectorItem.toStringAttributeCondition(this.attributeCondition, false));
            strBuilder.append("]");
        }
        if (this.index != null) {
            strBuilder.append("[");
            switch (this.index.type) {
                case VALUE: {
                    strBuilder.append(this.index.value);
                    break;
                }
                case LESS_THAN: {
                    strBuilder.append("<").append(this.index.value);
                    break;
                }
                case MORE_THAN: {
                    strBuilder.append(">").append(this.index.value);
                    break;
                }
                case EVEN: {
                    strBuilder.append(EVEN_SELECTOR);
                    break;
                }
                case ODD: {
                    strBuilder.append(ODD_SELECTOR);
                }
            }
            strBuilder.append("]");
        }
        return strBuilder.toString();
    }

    private static String toStringAttributeCondition(IAttributeCondition attributeCondition, boolean outputParenthesis) {
        if (attributeCondition instanceof AttributeConditionRelation) {
            AttributeConditionRelation relation = (AttributeConditionRelation)attributeCondition;
            if (outputParenthesis) {
                return "(" + MarkupSelectorItem.toStringAttributeCondition(relation.left, true) + " " + (Object)((Object)relation.type) + " " + MarkupSelectorItem.toStringAttributeCondition(relation.right, true) + ")";
            }
            return MarkupSelectorItem.toStringAttributeCondition(relation.left, true) + " " + (Object)((Object)relation.type) + " " + MarkupSelectorItem.toStringAttributeCondition(relation.right, true);
        }
        AttributeCondition attrCondition = (AttributeCondition)attributeCondition;
        return attrCondition.name + attrCondition.operator.text + (attrCondition.value != null ? "'" + attrCondition.value + "'" : "");
    }

    @Override
    public boolean anyLevel() {
        return this.anyLevel;
    }

    @Override
    public boolean matchesText(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        return !(!this.contentSelector && !this.textSelector || this.index != null && !MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index));
    }

    @Override
    public boolean matchesComment(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        return !(!this.contentSelector && !this.commentSelector || this.index != null && !MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index));
    }

    @Override
    public boolean matchesCDATASection(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        return !(!this.contentSelector && !this.cdataSectionSelector || this.index != null && !MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index));
    }

    @Override
    public boolean matchesDocTypeClause(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        return !(!this.contentSelector && !this.docTypeClauseSelector || this.index != null && !MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index));
    }

    @Override
    public boolean matchesXmlDeclaration(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        return !(!this.contentSelector && !this.xmlDeclarationSelector || this.index != null && !MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index));
    }

    @Override
    public boolean matchesProcessingInstruction(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        return !(!this.contentSelector && !this.processingInstructionSelector || this.index != null && !MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index));
    }

    @Override
    public boolean matchesElement(int markupBlockIndex, SelectorElementBuffer elementBuffer, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter) {
        if (this.textSelector || this.commentSelector || this.cdataSectionSelector || this.docTypeClauseSelector || this.xmlDeclarationSelector || this.processingInstructionSelector) {
            return false;
        }
        if (!this.contentSelector && this.requiresAttributesInElement && elementBuffer.attributeCount == 0) {
            return false;
        }
        if (!this.contentSelector && this.selectorPath != null && !TextUtil.equals(!this.html, (CharSequence)this.selectorPath, 0, this.selectorPathLen, elementBuffer.elementName, 0, elementBuffer.elementNameLen)) {
            return false;
        }
        if (!this.contentSelector && this.attributeCondition != null && !MarkupSelectorItem.matchesAttributeCondition(this.html, elementBuffer, this.attributeCondition)) {
            return false;
        }
        return this.index == null || MarkupSelectorItem.matchesIndex(markupBlockIndex, markupBlockMatchingCounter, this.index);
    }

    private static boolean matchesAttributeCondition(boolean html, SelectorElementBuffer elementBuffer, IAttributeCondition attributeCondition) {
        if (attributeCondition instanceof AttributeConditionRelation) {
            AttributeConditionRelation relation = (AttributeConditionRelation)attributeCondition;
            switch (relation.type) {
                case AND: {
                    return MarkupSelectorItem.matchesAttributeCondition(html, elementBuffer, relation.left) && MarkupSelectorItem.matchesAttributeCondition(html, elementBuffer, relation.right);
                }
                case OR: {
                    return MarkupSelectorItem.matchesAttributeCondition(html, elementBuffer, relation.left) || MarkupSelectorItem.matchesAttributeCondition(html, elementBuffer, relation.right);
                }
            }
        }
        AttributeCondition attrCondition = (AttributeCondition)attributeCondition;
        return MarkupSelectorItem.matchesAttribute(html, elementBuffer, attrCondition.name, attrCondition.operator, attrCondition.value);
    }

    private static boolean matchesAttribute(boolean html, SelectorElementBuffer elementBuffer, String attrName, AttributeCondition.Operator attrOperator, String attrValue) {
        boolean found = false;
        for (int i2 = 0; i2 < elementBuffer.attributeCount; ++i2) {
            if (!TextUtil.equals(!html, (CharSequence)attrName, 0, attrName.length(), elementBuffer.attributeBuffers[i2], 0, elementBuffer.attributeNameLens[i2])) continue;
            found = true;
            if (!(html && CLASS_ATTRIBUTE_NAME.equals(attrName) ? MarkupSelectorItem.matchesClassAttributeValue(attrOperator, attrValue, elementBuffer.attributeBuffers[i2], elementBuffer.attributeValueContentOffsets[i2], elementBuffer.attributeValueContentLens[i2]) : MarkupSelectorItem.matchesAttributeValue(attrOperator, attrValue, elementBuffer.attributeBuffers[i2], elementBuffer.attributeValueContentOffsets[i2], elementBuffer.attributeValueContentLens[i2]))) continue;
            return true;
        }
        if (found) {
            return false;
        }
        return AttributeCondition.Operator.NOT_EXISTS.equals((Object)attrOperator);
    }

    private static boolean matchesAttributeValue(AttributeCondition.Operator attrOperator, String attrValue, char[] elementAttrValueBuffer, int elementAttrValueOffset, int elementAttrValueLen) {
        switch (attrOperator) {
            case EQUALS: {
                return TextUtil.equals(true, (CharSequence)attrValue, 0, attrValue.length(), elementAttrValueBuffer, elementAttrValueOffset, elementAttrValueLen);
            }
            case NOT_EQUALS: {
                return !TextUtil.equals(true, (CharSequence)attrValue, 0, attrValue.length(), elementAttrValueBuffer, elementAttrValueOffset, elementAttrValueLen);
            }
            case STARTS_WITH: {
                return TextUtil.startsWith(true, elementAttrValueBuffer, elementAttrValueOffset, elementAttrValueLen, (CharSequence)attrValue, 0, attrValue.length());
            }
            case ENDS_WITH: {
                return TextUtil.endsWith(true, elementAttrValueBuffer, elementAttrValueOffset, elementAttrValueLen, (CharSequence)attrValue, 0, attrValue.length());
            }
            case CONTAINS: {
                return TextUtil.contains(true, elementAttrValueBuffer, elementAttrValueOffset, elementAttrValueLen, (CharSequence)attrValue, 0, attrValue.length());
            }
            case EXISTS: {
                return true;
            }
            case NOT_EXISTS: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)attrOperator));
    }

    private static boolean matchesClassAttributeValue(AttributeCondition.Operator attrOperator, String attrValue, char[] elementAttrValueBuffer, int elementAttrValueOffset, int elementAttrValueLen) {
        int i2;
        if (elementAttrValueLen == 0) {
            return MarkupSelectorItem.isEmptyOrWhitespace(attrValue);
        }
        for (i2 = 0; i2 < elementAttrValueLen && Character.isWhitespace(elementAttrValueBuffer[elementAttrValueOffset + i2]); ++i2) {
        }
        if (i2 == elementAttrValueLen) {
            return MarkupSelectorItem.isEmptyOrWhitespace(attrValue);
        }
        while (i2 < elementAttrValueLen) {
            int lastOffset = elementAttrValueOffset + i2;
            while (i2 < elementAttrValueLen && !Character.isWhitespace(elementAttrValueBuffer[elementAttrValueOffset + i2])) {
                ++i2;
            }
            if (MarkupSelectorItem.matchesAttributeValue(attrOperator, attrValue, elementAttrValueBuffer, lastOffset, elementAttrValueOffset + i2 - lastOffset)) {
                return true;
            }
            while (i2 < elementAttrValueLen && Character.isWhitespace(elementAttrValueBuffer[elementAttrValueOffset + i2])) {
                ++i2;
            }
        }
        return false;
    }

    private static boolean matchesIndex(int markupBlockIndex, MarkupSelectorFilter.MarkupBlockMatchingCounter markupBlockMatchingCounter, IndexCondition indexCondition) {
        int i2;
        if (markupBlockMatchingCounter.counters == null) {
            markupBlockMatchingCounter.indexes = new int[4];
            markupBlockMatchingCounter.counters = new int[4];
            Arrays.fill(markupBlockMatchingCounter.indexes, -1);
            Arrays.fill(markupBlockMatchingCounter.counters, -1);
        }
        for (i2 = 0; i2 < markupBlockMatchingCounter.indexes.length && markupBlockMatchingCounter.indexes[i2] >= 0 && markupBlockMatchingCounter.indexes[i2] != markupBlockIndex; ++i2) {
        }
        if (i2 == markupBlockMatchingCounter.indexes.length) {
            int[] newMarkupBlockMatchingIndexes = new int[markupBlockMatchingCounter.indexes.length + 4];
            int[] newMarkupBlockMatchingCounters = new int[markupBlockMatchingCounter.counters.length + 4];
            Arrays.fill(newMarkupBlockMatchingIndexes, -1);
            Arrays.fill(newMarkupBlockMatchingCounters, -1);
            System.arraycopy(markupBlockMatchingCounter.indexes, 0, newMarkupBlockMatchingIndexes, 0, markupBlockMatchingCounter.indexes.length);
            System.arraycopy(markupBlockMatchingCounter.counters, 0, newMarkupBlockMatchingCounters, 0, markupBlockMatchingCounter.counters.length);
            markupBlockMatchingCounter.indexes = newMarkupBlockMatchingIndexes;
            markupBlockMatchingCounter.counters = newMarkupBlockMatchingCounters;
        }
        if (markupBlockMatchingCounter.indexes[i2] == -1) {
            markupBlockMatchingCounter.indexes[i2] = markupBlockIndex;
            markupBlockMatchingCounter.counters[i2] = 0;
        } else {
            int n = i2;
            markupBlockMatchingCounter.counters[n] = markupBlockMatchingCounter.counters[n] + 1;
        }
        switch (indexCondition.type) {
            case VALUE: {
                if (indexCondition.value == markupBlockMatchingCounter.counters[i2]) break;
                return false;
            }
            case LESS_THAN: {
                if (indexCondition.value > markupBlockMatchingCounter.counters[i2]) break;
                return false;
            }
            case MORE_THAN: {
                if (indexCondition.value < markupBlockMatchingCounter.counters[i2]) break;
                return false;
            }
            case EVEN: {
                if (markupBlockMatchingCounter.counters[i2] % 2 == 0) break;
                return false;
            }
            case ODD: {
                if (markupBlockMatchingCounter.counters[i2] % 2 != 0) break;
                return false;
            }
        }
        return true;
    }

    private static boolean isEmptyOrWhitespace(String target) {
        if (target == null) {
            return true;
        }
        int targetLen = target.length();
        if (targetLen == 0) {
            return true;
        }
        char c0 = target.charAt(0);
        if (c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z') {
            return false;
        }
        for (int i2 = 0; i2 < targetLen; ++i2) {
            char c = target.charAt(i2);
            if (c == ' ' || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    static final class IndexCondition {
        static IndexCondition INDEX_CONDITION_ODD = new IndexCondition(IndexConditionType.ODD, -1);
        static IndexCondition INDEX_CONDITION_EVEN = new IndexCondition(IndexConditionType.EVEN, -1);
        final IndexConditionType type;
        final int value;

        IndexCondition(IndexConditionType type, int value) {
            this.type = type;
            this.value = value;
        }

        static enum IndexConditionType {
            VALUE,
            LESS_THAN,
            MORE_THAN,
            EVEN,
            ODD;

        }
    }

    static final class AttributeConditionRelation
    implements IAttributeCondition {
        final Type type;
        final IAttributeCondition left;
        final IAttributeCondition right;

        AttributeConditionRelation(Type type, IAttributeCondition left, IAttributeCondition right) {
            this.type = type;
            this.left = left;
            this.right = right;
        }

        static enum Type {
            AND,
            OR;

        }
    }

    static final class AttributeCondition
    implements IAttributeCondition {
        final String name;
        final Operator operator;
        final String value;

        AttributeCondition(String name, Operator operator, String value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        static enum Operator {
            EQUALS("="),
            NOT_EQUALS("!="),
            STARTS_WITH("^="),
            ENDS_WITH("$="),
            EXISTS("*"),
            NOT_EXISTS("!"),
            CONTAINS("*=");

            private String text;

            private Operator(String text) {
                this.text = text;
            }
        }
    }

    static interface IAttributeCondition {
    }
}

