/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.ParsingLocatorUtil;

final class ParsingMarkupUtil {
    private ParsingMarkupUtil() {
    }

    static int findNextStructureEndAvoidQuotes(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (c == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c == '\"' && !inApos) {
                inQuotes = !inQuotes;
            } else if (c == '\'' && !inQuotes) {
                inApos = !inApos;
            } else if (c == '>' && !inQuotes && !inApos) {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextStructureEndDontAvoidQuotes(char[] text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (c == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c == '>') {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextStructureStart(char[] text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (c == '\n') {
                colIndex = i2;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c == '<') {
                locator[1] = locator[1] + (i2 - colIndex);
                return i2;
            }
            ++i2;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextWhitespaceCharWildcard(char[] text, int offset, int maxi, boolean avoidQuotes, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (avoidQuotes && !inApos && c == '\"') {
                inQuotes = !inQuotes;
            } else if (avoidQuotes && !inQuotes && c == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && (c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c))) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i2;
        }
        return -1;
    }

    static int findNextNonWhitespaceCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            boolean isWhitespace;
            char c = text[i2];
            boolean bl = isWhitespace = c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c);
            if (!isWhitespace) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i2;
        }
        return -1;
    }

    static int findNextOperatorCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (c == '=' || c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c)) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i2;
        }
        return -1;
    }

    static int findNextNonOperatorCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (!(c == '=' || c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c))) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i2;
        }
        return -1;
    }

    static int findNextAnyCharAvoidQuotesWildcard(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (!inApos && c == '\"') {
                if (inQuotes) {
                    ParsingLocatorUtil.countChar(locator, c);
                    return ++i2 < maxi ? i2 : -1;
                }
                inQuotes = true;
            } else if (!inQuotes && c == '\'') {
                if (inApos) {
                    ParsingLocatorUtil.countChar(locator, c);
                    return ++i2 < maxi ? i2 : -1;
                }
                inApos = true;
            } else if (!inQuotes && !inApos) {
                return i2;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i2;
        }
        return -1;
    }

    static int findCharacterSequence(char[] text, int offset, int maxi, int[] locator, char[] charSeq) {
        if (charSeq == null || charSeq.length == 0) {
            return offset;
        }
        char c1 = charSeq[0];
        int i2 = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i2];
            if (c == c1) {
                int j;
                for (j = 1; j < charSeq.length && i2 + j < maxi && text[i2 + j] == charSeq[j]; ++j) {
                }
                if (j >= charSeq.length) {
                    return i2;
                }
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i2;
        }
        return -1;
    }
}

