/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.HtmlAutoCloseElement;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.ParseStatus;

class HtmlAutoOpenCloseElement
extends HtmlAutoCloseElement {
    private final char[][] autoOpenParents;
    private final char[][] autoOpenLimits;

    HtmlAutoOpenCloseElement(String name, String[] autoOpenParents, String[] autoOpenLimits, String[] autoCloseElements, String[] autoCloseLimits) {
        super(name, autoCloseElements, autoCloseLimits);
        char[][] autoOpenLimitsCharArray;
        if (autoOpenParents == null) {
            throw new IllegalArgumentException("The array of auto-open parents cannot be null");
        }
        char[][] autoOpenParentsCharArray = new char[autoOpenParents.length][];
        for (int i2 = 0; i2 < autoOpenParentsCharArray.length; ++i2) {
            autoOpenParentsCharArray[i2] = autoOpenParents[i2].toCharArray();
        }
        if (autoOpenLimits != null) {
            autoOpenLimitsCharArray = new char[autoOpenLimits.length][];
            for (int i3 = 0; i3 < autoOpenLimitsCharArray.length; ++i3) {
                autoOpenLimitsCharArray[i3] = autoOpenLimits[i3].toCharArray();
            }
        } else {
            autoOpenLimitsCharArray = null;
        }
        this.autoOpenParents = autoOpenParentsCharArray;
        this.autoOpenLimits = autoOpenLimitsCharArray;
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if ((autoOpenEnabled || autoCloseEnabled) && !status.isAutoOpenCloseDone()) {
            if (autoCloseEnabled) {
                status.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            }
            if (autoOpenEnabled) {
                status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            }
            return;
        }
        handler.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if ((autoOpenEnabled || autoCloseEnabled) && !status.isAutoOpenCloseDone()) {
            if (autoCloseEnabled) {
                status.setAutoCloseRequired(this.autoCloseRequired, this.autoCloseLimits);
            }
            if (autoOpenEnabled) {
                status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            }
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }
}

